/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * Additional information about a lock. <p>
 *
 * Copyright (c) SAP AG 2002
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: IExtendedLockInfo.java,v 1.1 2002/10/07 12:12:08 jre Exp $
 */

public interface IExtendedLockInfo {

  /**
   * Returns the RID of the resource on which the lock was created
   *
   * @return the RID of the resource on which the lock was created (or <code>
   *      null</code> when unknown)
   */
  public RID getRequestRID();
}

