/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.Date;

/**
 * Additional content meta data. <p>
 *
 * Copyright (c) SAP AG 2002-2004
 * @author julian.reschke@greenbytes.de
 * @version $Revision: 1.2 $
 */
public interface IEntityMetadata {

  /**
   * Returns the the entity-tag for the content (see <a
   * href="http://greenbytes.de/tech/webdav/rfc2616.html#rfc.section.3.11">RFC2616</a>, section 3.11) and <a
   * href="http://greenbytes.de/tech/webdav/rfc2616.html#rfc.section.14.19">RFC2616</a>, section 14.19).
   * Note that the entity tag may be a <em>weak</em> entity tag (indicated
   * by a leading "W/"). Only strong entity tags can be used to assert
   * octet-by-octet entity body identity, though.
   * <p>
   * The Format MUST be either:
   * <ul>
   *   <li>"\"xyz\"" (quoted strong entity tag),</li>
   *   <li>"W/\"xyz\"" (weak entity tag) or</li>
   * </ul>
   * Note that the double quotes are part of the entity tag.
   * @return entity tag or <code>null</code> when not known
   */
  public String getEntityTag()
    throws ResourceException;


  /**
   * @return the expiry date for the content (see <a
   *      href="http://www.ietf.org/rfc/rfc2616">RFC2616</a>, section 14.21) or
   *      <code>null</code> when not specified
   */
  public Date getExpiryDate()
    throws ResourceException;


  /**
   * @return the content language (see <a
   *      href="http://greenbytes.de/tech/webdav/rfc2616.html#rfc.section.14.12">RFC2616</a>, section 14.12) or
   *      <code>null</code> when not known
   */
  public String getLanguage()
    throws ResourceException;


  /**
   * @return the last modification date (see <a
   *      href="http://greenbytes.de/tech/webdav/rfc2616.html#rfc.section.14.29">RFC2616</a>, section 14.29) or
   *      <code>null</code> when not known
   */
  public Date getLastModified()
    throws ResourceException;
}
