/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.Collection;

/**
 * Parameter collection for the copy() and move() methods in IResource and
 * ICollection. <p>
 *
 * <pre>
 * Defaults:
 * overwrite         = false
 * omitProperties    = false
 * copyChildren      = true
 * copyInternalLinks = true
 * copyExternalLinks = true
 * </pre> <p>
 *
 * copyChildren, copyInternalLinks and copyExternalLinks are used for deep copy
 * of collections only. <p>
 *
 * Copyright (c) SAP AG 2002
 *
 * @author m.breitenfelder@sap.com
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/api/com/sapportals/wcm/repository/ICopyParameter.java#9
 *      $
 */

public interface ICopyParameter {

  /**
   * Gets the value of this parameter.
   *
   * @return The overwrite value
   */
  public boolean getOverwrite();


  /**
   * Gets the value of this parameter.
   *
   * @return The ignorePropertyFailures value
   */
  public boolean getIgnorePropertyFailures();


  /**
   * Gets the value of this parameter.
   *
   * @return The copyChildren value
   */
  public boolean getCopyChildren();


  /**
   * Gets the value of this parameter.
   *
   * @return The copyInternalLinks value
   */
  public boolean getCopyInternalLinks();


  /**
   * Gets the value of this parameter.
   *
   * @return The copyExternalLinks value
   */
  public boolean getCopyExternalLinks();


  /**
   * Get the first resource exception. This exception will contain a reference
   * to the next exception if more then one copy operation failed.
   *
   * @return The first resource exception
   */
  public ResourceException getFirstResourceException();


  /**
   * Copy all subfolders recursively (deep copy of collections only)
   *
   * @param value
   */
  public void setCopyChildren(boolean value);


  /**
   * Existing destination will be overwritten.
   *
   * @param value
   */
  public void setOverwrite(boolean value);


  /**
   * Create the copy even if some or all properties could not be set on the
   * destination resource.
   *
   * @param value
   */
  public void setIgnorePropertyFailures(boolean value);


  /**
   * Include/exclude internal links (deep copy of collections only)
   *
   * @param value
   */
  public void setCopyInternalLinks(boolean value);


  /**
   * Include/exclude external links (deep copy of collections only)
   *
   * @param value
   */
  public void setCopyExternalLinks(boolean value);
}
