/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.*;

import java.util.Map;

/**
 * Interface for collection version (revision) resources. <p>
 *
 * Copyright (c) SAP AG 2002-2004
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: ICollectionVersionResource.java,v 1.3 2003/01/02 13:50:55 jre
 *      Exp $
 */
public interface ICollectionVersionResource {

  /**
   * @return a mapping of internal member names to RIDs to the version history
   *      resources (for an ordered collection, this will be a SortedMap).
   * @throws ResourceException
   */
  public Map getVersionControlledBindingSet()
    throws ResourceException;

  /**
   * Returns information about the collection version's ordering, where the
   * following URIs are reserved: <p>
   *
   * "DAV:unordered": unordered collection<br>
   * "DAV:custom": client-maintained ordering, no additional information about
   * the ordering semantics available <p>
   *
   * Any other URI identifies an ordering for which additional information
   * semantics MAY be available at the given URI
   *
   * @return the ordering type
   * @exception ResourceException Exception raised in failure situation
   */
  public IUri getOrderingType()
    throws ResourceException;
}
