/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * Holds status information returned upon a successfull call to {@link
 * IVersionControlledResource#checkOut(boolean, boolean)} or {@link IVersionResource#checkOut(boolean)} or
 * <p>
 *
 * Copyright 2002 (c) SAP AG
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: ICheckOutInfo2.java,v 1.1 2002/07/29 12:16:49 jre Exp $
 */
public interface ICheckOutInfo2 extends ICheckOutInfo {

  /**
   * @return RID of created working resource (or <code>null</code> when no
   *      working resource was created).
   * @exception ResourceException Exception raised in failure situation
   */
  public RID getWorkingResourceRID()
    throws ResourceException;

}

