/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.*;

/**
 * Holds status information returned upon a successfull check-in. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: ICheckInInfo.java,v 1.12 2002/10/12 17:56:28 jre Exp $
 */

public interface ICheckInInfo {

  /**
   * @return The revisionURI value
   * @deprecated As of EP 5.0 SP3, replaced by {@link #getRevisionRID()}
   */
  public URI getRevisionURI();


  /**
   * Returns the RID of the version resource that was created during the checkin
   * operation.
   *
   * @return the RID of the version resource that was created during the checkin
   *      operation.
   */
  public RID getRevisionRID();


  /**
   * @return the revision ID (version number) of the version resource that was
   *      created during the checkin operation.
   */
  public String getRevisionID();
}

