/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.*;

/**
 * Interface for bindable resources (see <a
 * href="http://greenbytes.de/tech/webdav/draft-ietf-webdav-bind-latest.html">
 * WebDAV BIND protocol</a> ). <p>
 *
 * Copyright (c) SAP AG 2002-2004
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: IBindableResource.java,v 1.3 2004/03/23 13:20:46 jre Exp $
 */
public interface IBindableResource {

  /**
   * @return set of all existing bindings known by the repository manager
   * @exception ResourceException Exception raised in failure situation
   */
  public IRidSet getBindings()
    throws ResourceException;

  /**
   * @return a globally unique identifier for this resource
   * @exception ResourceException Exception raised in failure situation
   */
  public IUri getGloballyUniqueId()
    throws ResourceException;

  /**
   * @return whether this resource allows additional bindings (this may be
   *      disallowed for specific resource types)
   * @exception ResourceException Exception raised in failure situation
   */
  public boolean supportsAdditionalBinds()
    throws ResourceException;
}

