/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.*;

/**
 * Interface for collections that can explicitly control the bindings they
 * contain (see <a href="http://greenbytes.de/tech/webdav/draft-ietf-webdav-bind-latest.html">
 * WebDAV BIND protocol</a> ). <p>
 *
 * <em>EXPERIMENTAL</em> <p>
 *
 * Copyright (c) SAP AG 2002-2004
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: IBindController.java,v 1.3 2004/03/23 13:20:46 jre Exp $
 */
public interface IBindController {

  /**
   * Adds a new member name to the collection referencing the identified
   * resource.
   *
   * @param memberName member name to be added to collection
   * @param targetRid resource to bind to
   * @param position position in target collection (may be <code>null</code> )
   * @param overwrite set to <code>true</code> if an existing resource binding
   *      may be overwritten
   * @return whether an existing internal member was overwritten
   * @exception ResourceException Exception raised in failure situation
   */
  public boolean createBind(String memberName, IPosition position, RID targetRid, boolean overwrite)
    throws ResourceException;

  /**
   * Adds a new member name to the collection referencing the identified
   * resource.
   *
   * @param memberName member name to be added to collection
   * @param targetResource resource to bind to
   * @param position position in target collection (may be <code>null</code> )
   * @param overwrite set to <code>true</code> if an existing resource binding
   *      may be overwritten
   * @return whether an existing internal member was overwritten
   * @exception ResourceException Exception raised in failure situation
   */
  public boolean createBind(String memberName, IPosition position, IResource targetResource, boolean overwrite)
    throws ResourceException;
}

