/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * The requested RID contains an external link. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/api/com/sapportals/wcm/repository/ExternalLinkException.java#10
 *      $
 */
public class ExternalLinkException extends ResourceException {

  private String knownRIDPart;

  private String unknownRIDPart;

  /**
   * Constructs a new exception
   *
   * @param msg The message text
   * @param knownRIDPart part of thr requested URI that is known to the
   *      repository (format: URI-encoded)
   * @param unknownRIDPart "remainder" of the URI (format: not encoded)
   */
  public ExternalLinkException(String msg, String knownRIDPart, String unknownRIDPart) {
    super(msg, false);
    this.knownRIDPart = knownRIDPart;
    this.unknownRIDPart = unknownRIDPart;
  }

  /**
   * Constructs a new exception
   *
   * @param knownRIDPart part of thr requested URI that is known to the
   *      repository (format: URI-encoded)
   * @param unknownRIDPart TBD: Description of the incoming method parameter
   */
  public ExternalLinkException(String knownRIDPart, String unknownRIDPart) {
    super(false);
    this.knownRIDPart = knownRIDPart;
    this.unknownRIDPart = unknownRIDPart;
  }

  /**
   * @return knownURIPart
   * @deprecated as of NW04.
   */
  public String getKnownURIPart() {
    return this.knownRIDPart;
  }

  /**
   * @return unknownURIPart
   * @deprecated as of NW04.
   */
  public String getUnknownURIPart() {
    return this.unknownRIDPart;
  }


  /**
   * Returns the part of the requested RID that was known to the repository
   * (format: URI-encoded), may be <code>null</code>
   *
   * @return part of the requested RID that was known to the repository (format:
   *      URI-encoded), may be <code>null</code>
   */
  public String getKnownRIDPart() {
    return this.knownRIDPart;
  }

  /**
   * Returns the "remainder" of the RID (format: not encoded)
   *
   * @return "remainder" of the RID (format: not encoded)
   */
  public String getUnknownRIDPart() {
    return this.unknownRIDPart;
  }
}
