/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.enum.LockDepth;
import com.sapportals.wcm.repository.enum.LockScope;
import com.sapportals.wcm.repository.enum.LockType;
import com.sapportals.wcm.util.uri.RID;

import java.util.Date;

/**
 * This object represents an active deep lock on a resource. <p>
 *
 * Copyright (c) SAP AG 2002
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: ExtendedLockInfo.java,v 1.1 2002/10/07 12:12:08 jre Exp $
 */
public class ExtendedLockInfo extends LockInfo implements ILockInfo, IExtendedLockInfo {

  private final RID requestRID;

  /**
   * @param type lock type
   * @param scope lock scope
   * @param depth lock depth
   * @param owner lock owner
   * @param timeout timeout in seconds
   * @param lockToken The lock token must be either an absolute URI (as defined
   *      in <a href="http://www.ietf.org/rfc/rfc2396.txt">RFC2396</a> or a
   *      relative URI reference (in which case the <a
   *      href="http://greenbytes.de/tech/webdav/rfc2518.html#rfc.section.6.4">
   *      opaquelocktoken</a> URI scheme is assumed).
   * @param created creation time
   * @param ownerInfoFromClient A client can submit his own owner information
   *      that SHOULD be returned upon lock discovery. If present, the format
   *      MUST be the XML serialization of a <a
   *      href="http://www.greenbytes.de/tech/webdav/rfc2518.html#ELEMENT_owner"
   *      >DAV:owner</a> element.
   * @param requestRID RID of resource on which the lock was created
   */
  public ExtendedLockInfo(LockType type, LockScope scope, LockDepth depth, String owner, int timeout,
    String lockToken, Date created, XMLMarkup ownerInfoFromClient, RID requestRID) {
    super(type, scope, depth, owner, timeout, lockToken, created,
      ownerInfoFromClient);
    this.requestRID = requestRID;
  }

  public RID getRequestRID() {
    return this.requestRID;
  }

}

