/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * The RID of the new revision is different from the RID that the application
 * excepted when chacking out.
 */
public class ExpectedCheckInRIDException extends ResourceException {

  private RID newRid = null;

  /**
   * Constructs a new exception
   *
   * @param resourceID The ID of the resource the exception belongs to
   * @param newRID TBD: Description of the incoming method parameter
   */
  public ExpectedCheckInRIDException(RID resourceID, RID newRID) {
    super(resourceID, false);
    this.newRid = newRID;
  }

  /**
   * Returns the expected check-in RID
   *
   * @return the expected check-in RID
   */
  public RID getNewExpectedCheckInRID() {
    return this.newRid;
  }

  /**
   * Sets the expected check-in RID
   *
   * @param newRID newExpectedCheckInRIDException to be set
   */
  public void setNewExpectedCheckInRIDException(RID newRID) {
    this.newRid = newRID;
  }
}
