/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: CopyParameter.java,v 1.3 2004/05/27 11:33:52 jre Exp $
 */

package com.sapportals.wcm.repository;


/**
 * Parameter collection for the copy() and move() methods in {@link IResource} and
 * ICollection. Defaults: overwrite = false omitProperties = false copyChildren
 * = true copyInternalLinks = true copyExternalLinks = true copyChildren,
 * copyInternalLinks and copyExternalLinks are used for deep copy of collections
 * only.
 * <p>
 * Copyright (c) SAP AG 2001-2004
 * @version $Revision: 1.3 $
 */
public class CopyParameter implements ICopyParameter {

  private boolean copyChildren = true;
  private boolean overwrite = false;
  private boolean ignorePropertyFailures = false;
  private boolean copyInternalLinks = true;
  private boolean copyExternalLinks = true;

  private ResourceErrors resourceErrors = null;

  public CopyParameter() {
    this.overwrite = false;
    this.ignorePropertyFailures = false;
    this.copyChildren = true;
    this.copyInternalLinks = true;
    this.copyExternalLinks = true;
  }

  public CopyParameter(boolean overwrite) {
    this();
    this.overwrite = overwrite;
  }

  public CopyParameter(boolean overwrite, boolean ignorePropertyFailures) {
    this();
    this.ignorePropertyFailures = ignorePropertyFailures;
    this.overwrite = overwrite;
  }

  public CopyParameter(boolean overwrite, boolean ignorePropertyFailures, boolean copyChildren) {
    this();
    this.copyChildren = copyChildren;
    this.overwrite = overwrite;
    this.ignorePropertyFailures = ignorePropertyFailures;
  }

  public CopyParameter(boolean overwrite, boolean ignorePropertyFailures, boolean copyChildren, boolean copyInternalLinks) {
    this();
    this.copyChildren = copyChildren;
    this.overwrite = overwrite;
    this.ignorePropertyFailures = ignorePropertyFailures;
    this.copyInternalLinks = copyInternalLinks;
  }

  public CopyParameter(boolean overwrite, boolean ignorePropertyFailures, boolean copyChildren, boolean copyInternalLinks, boolean copyExternalLinks) {
    this.copyChildren = copyChildren;
    this.overwrite = overwrite;
    this.ignorePropertyFailures = ignorePropertyFailures;
    this.copyInternalLinks = copyInternalLinks;
    this.copyExternalLinks = copyExternalLinks;
  }


  public boolean getCopyChildren() {
    return this.copyChildren;
  }

  public boolean getOverwrite() {
    return this.overwrite;
  }

  public boolean getIgnorePropertyFailures() {
    return this.ignorePropertyFailures;
  }

  public boolean getCopyInternalLinks() {
    return this.copyInternalLinks;
  }

  public boolean getCopyExternalLinks() {
    return this.copyExternalLinks;
  }

  public ResourceException getFirstResourceException() {
    return this.resourceErrors.getResourceException();
  }

  public void setOverwrite(boolean value) {
    this.overwrite = value;
  }

  public void setIgnorePropertyFailures(boolean value) {
    this.ignorePropertyFailures = value;
  }

  public void setCopyChildren(boolean value) {
    this.copyChildren = value;
  }

  public void setCopyInternalLinks(boolean value) {
    this.copyInternalLinks = value;
  }

  public void setCopyExternalLinks(boolean value) {
    this.copyExternalLinks = value;
  }

  // ----- Not in interface -----

  public ResourceErrors getResourceErrors() {
    return this.resourceErrors;
  }

  public void setResourceErrors(ResourceErrors errors) {
    this.resourceErrors = errors;
  }
}
