/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sap.netweaver.bc.rf.common.content.IContentMetadata;

import java.util.Date;

/**
 * TBD: Description of the class.
 */
public class ContentMetadata implements IContentMetadata {

  private final long length;
  private final String type;
  private final String encoding;
  private final String entityTag;
  private final Date expiryDate;
  private final String language;
  private final Date lastModified;

  public ContentMetadata(long length, String type, String encoding, String entityTag, Date expiryDate,
    String language, Date lastModified) {
    this.length = length;
    this.type = this.getMimeType(type);
    this.encoding = (encoding == null) ? this.getEncoding(type) : encoding;
    this.entityTag = entityTag;
    this.expiryDate = expiryDate;
    this.language = language;
    this.lastModified = lastModified;
  }

  public long getContentLength() {
    return this.length;
  }

  public String getContentType() {
    return this.type;
  }

  public String getContentEncoding() {
    return this.encoding;
  }

  public String getContentLanguage() {
    return this.language;
  }

  public String getETag() {
    return this.entityTag;
  }

  public Date getExpires() {
    return this.expiryDate;
  }

  public Date getLastModified() {
    return this.lastModified;
  }

  private String getMimeType(String contentType) {

    if (contentType == null) {
      return null;
    }
    else {
      int pos = contentType.indexOf(";");
      if (pos < 0) {
        return contentType.trim();
      }
      else {
        return contentType.substring(0, pos).trim();
      }
    }
  }

  private String getEncoding(String contentType) {

    if (contentType == null) {
      return null;
    }
    else {
      int pos = contentType.indexOf(";");
      if (pos < 0) {
        return null;
      }
      else {
        String modifiers = contentType.substring(pos + 1);
        java.util.StringTokenizer st = new java.util.StringTokenizer(modifiers, ";");

        while (st.hasMoreTokens()) {

          String tok = st.nextToken().trim();

          if (tok.toLowerCase().startsWith("charset=")) {

            String val = tok.substring("charset=".length());
            int from = 0;
            int to = val.length();

            if (val.charAt(0) == '"' || val.charAt(0) == '\'') {
              from += 1;
            }

            if (val.charAt(to - 1) == '"' || val.charAt(to - 1) == '\'') {
              to -= 1;
            }

            return val.substring(from, to);
          }
        }

        return null;
      }
    }
  }
}
