/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.util.uri.RID;

import com.sapportals.wcm.util.uri.URI;

/**
 * The resource is checked out by another user.
 * <p>
 * Copyright SAP AG 2001-2004
 */
public class CheckedOutException extends ResourceException {

  private String userID = null;

  /**
   * @deprecated as of NW04.
   */
  public CheckedOutException(URI resourceID, String userID) {
    super(resourceID, false);
    this.userID = userID;
  }

  /**
   * @deprecated as of NW04.
   */
  public CheckedOutException(String msg, URI resourceID, String userID) {
    super(msg, resourceID, false);
    this.userID = userID;
  }

  /**
   * Constructs a new exception
   *
   * @param resourceID The ID of the resource this exception belongs to
   *      (optional)
   * @param userID The ID of the user that has checked out the resource
   *      (optional)
   */
  public CheckedOutException(RID resourceID, String userID) {
    super(resourceID, false);
    this.userID = userID;
  }

  /**
   * Constructs a new exception
   *
   * @param msg The exception message text
   * @param resourceID The ID of the resource this exception belongs to
   *      (optional)
   * @param userID The ID of the user that has checked out the resource
   *      (optional)
   */
  public CheckedOutException(String msg, RID resourceID, String userID) {
    super(msg, resourceID, false);
    this.userID = userID;
  }

  /**
   * Returns the ID of the user that has checked out the resource. Can be <code>
   * null</code>.
   *
   * @return the ID of the user that has checked out the resource. Can be <code>
   *      null</code>.
   */
  public String getUserID() {
    return this.userID;
  }
}
