/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * The user is not authorized.
 */
public class AuthorizationRequiredException extends ResourceException {

  private String systemID = null;

  /**
   * Constructs a new exception
   */
  public AuthorizationRequiredException() {
    super(false);
  }

  /**
   * Constructs a new exception
   *
   * @param msg The message
   * @param systemID The ID of the system authorization is required for
   */
  public AuthorizationRequiredException(String msg, String systemID) {
    super(msg, false);
    this.systemID = systemID;
  }

  /**
   * Constructs a new exception
   *
   * @param systemID The ID of the system authorization is required for
   */
  public AuthorizationRequiredException(String systemID) {
    super(false);
    this.systemID = systemID;
  }

  /**
   * Returns the ID of the system authorization is required for. Can be <code>
   * null</code>
   *
   * @return the ID of the system authorization is required for. Can be <code>
   *      null</code>
   */
  public String getSystemID() {
    return this.systemID;
  }
}
