/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.util.uri.RID;

import com.sapportals.wcm.util.uri.URI;

/**
 * Access to a resource or property is denied because the user does not have the
 * required authorization. <p>
 *
 * Copyright (c) SAP AG 2001-2004
 * @author m.breitenfelder@sap.com
 */
public class AccessDeniedException extends ResourceException {

  String m_permissionName = null;
  String m_userID = null;

  /**
   * Constructs a new exception
   *
   * @param msg The exception message text
   */
  public AccessDeniedException(String msg) {
    super(msg, false);
  }

  /**
   * This constructor is used by the framework to use this exception as a
   * wrapper for a new exception class of the repository manager API.
   *
   * @param newEx The new exception.
   */
  public AccessDeniedException(
    com.sap.netweaver.bc.rf.common.security.AccessDeniedException newEx,
    String permissionName,
    String userID) {
    super(newEx);
    m_userID = userID;
    m_permissionName = permissionName;
  }

  /**
   * @deprecated as of NW04.
   */
  public AccessDeniedException(String msg, URI resourceID, String permissionName, String userID) {
    super(msg, resourceID, false);
    m_userID = userID;
    m_permissionName = permissionName;
  }

  /**
   * Constructs a new exception
   *
   * @param msg The exception message text
   * @param resourceID The ID of the resource this exception belongs to
   *      (optional)
   * @param permissionName The name of the required permission the user does not
   *      have (optional)
   * @param userID The user ID (optional)
   */
  public AccessDeniedException(String msg, RID resourceID, String permissionName, String userID) {
    super(msg, resourceID, false);
    m_userID = userID;
    m_permissionName = permissionName;
  }

  /**
   * @deprecated as of NW04.
   */
  public AccessDeniedException(URI resourceID, String permissionName, String userID) {
    super(resourceID, false);
    m_userID = userID;
    m_permissionName = permissionName;
  }

  /**
   * Constructs a new exception
   *
   * @param resourceID The ID of the resource this exception belongs to
   *      (optional)
   * @param permissionName The name of the required permission the user does not
   *      have (optional)
   * @param userID The user ID (optional)
   */
  public AccessDeniedException(RID resourceID, String permissionName, String userID) {
    super(resourceID, false);
    m_userID = userID;
    m_permissionName = permissionName;
  }

  /**
   * Returns the name of the required permission the user does not have. Can be
   * <code>null</code> .
   *
   * @return the name of the required permission the user does not have. Can be
   *      <code>null</code> .
   */
  public String getPermissionName() {
    return m_permissionName;
  }

  /**
   * Returns the ID of the user. Can be <code>null</code> .
   *
   * @return the ID of the user. Can be <code>null</code> .
   */
  public String getUserID() {
    return m_userID;
  }

}
