/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URI;

/**
 * Abstract base class for property exceptions. <p>
 * 
 * Copyright (c) SAP AG 2001-2004
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/api/com/sapportals/wcm/repository/PropertyUnchangedException.java#6
 *      $
 */
public class AbstractPropertyException extends ResourceException {

  private IPropertyName name = null;

  /**
   * @deprecated as of NW04.
   */
  public AbstractPropertyException(String msg, URI resourceID, IPropertyName propertyName) {
    super(msg, resourceID, false);
    this.name = propertyName;
  }

  /**
   * Constructs a new PropertyUnchangedException
   *
   * @param msg The message text
   * @param resourceID The ID of the resource that caused the exception
   *      (optional)
   * @param propertyName The name of the property that caused the exception
   *      (optional)
   */
  public AbstractPropertyException(String msg, RID resourceID, IPropertyName propertyName) {
    super(msg, resourceID, false);
    this.name = propertyName;
  }

  /**
   * Returns the name of the property that caused the exception
   *
   * @return the name of the property that caused the exception
   */
  public IPropertyName getPropertyName() {
    return this.name;
  }
}
