/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: ITransactionEndsListener.java,v 1.1 2005/01/21 11:49:20 mbo Exp $
 */

package com.sapportals.wcm;

/**
 * Callback interface for IFrameworkTransactions. 
 * <p>
 * When a framework transaction ends the registered listeners are
 * called with via the wasCommitted or wasRollbacked methods each.
 * <p>
 * Copyright (c) SAP AG 2004
 * @author martin.boettcher@greenbytes.de
 */
public interface ITransactionEndsListener {

  /**
   * 
   * @return a unique key for this transaction.
   */
  public String getKey();
  
  /**
   * Is called when the corresponding framework transaction WAS committed.    
   */
  public void wasCommitted(IFrameworkTransaction context);
  
  /**
   * Is called when the corresponding framework transaction WAS rolled back.    
   */
  public void wasRolledback(IFrameworkTransaction context);
  
}
