/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline.utils;

import com.sapportals.wcm.service.pipeline.IConst;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

import java.util.StringTokenizer;
import java.util.Vector;

import org.w3c.dom.*;

/**
 * Congerie of static utility methods (deprecated). <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/pipeline/api/com/sapportals/wcm/service/pipeline/utils/XMLUtils.java#4
 *      $
 */
public class XMLUtils implements IConst {
  
  private static com.sap.tc.logging.Location LOG = com.sap.tc.logging.Location.getLocation(XMLUtils.class);
    
  private static String STYLESHEET_PI = "xml-stylesheet";
  private static String TYPE_ATTR = "type";
  private static String MIME_XSL = "text/xsl";
  private static String HREF = "href";

  public XMLUtils() { }

  /**
   * This method adds a top level parameter to the XML document <p>
   *
   *
   *
   * @param document XML DOM
   * @param key key of the top level parameter
   * @param value value of the top level parameter
   * @param name topLevelParam to be added
   */
  public static void addTopLevelParam(Document document, String name, String key, String value) {
    Attr attr;
    Element root = document.getDocumentElement();
    Element elem = document.createElement(name);
    elem.setAttribute("name", key);
    elem.setAttribute("select", "'" + value + "'");
    root.insertBefore(elem, root.getFirstChild());
  }

  /**
   * This method extracts the stylesheet URI form a XML document <p>
   *
   *
   *
   * @param document XML DOM
   * @return stylesheet URI
   */
  public final static String getStylesheetUri(Document document) {
    String uri = "";
    try {
      boolean found = false;
      Enumeration pis = getAllPIs(document, STYLESHEET_PI).elements();
      while (!found && pis.hasMoreElements()) {
        Hashtable attributes = getPIPseudoAttributes((ProcessingInstruction)pis.nextElement());
        String type = (String)attributes.get(TYPE_ATTR);
        if ((type != null) && (type.equals(MIME_XSL))) {
          uri = (String)attributes.get(HREF);
          found = uri != null;
        }
      }
    }
    catch (Exception ex) {
      LOG.debugT(ex.getMessage());
    }
    return uri;
  }

  /**
   * This method returns a vector of PI nodes based on the PI target name. <p>
   *
   *
   *
   * @param document XML DOM
   * @param name target name of the PI
   * @return allPIs
   * @returns vector with all PIs
   */
  public final static Vector getAllPIs(Document document, String name) {
    return getAllPIs(document, name, false);
  }

  /**
   * This method returns all PI nodes based on the target name. <p>
   *
   *
   *
   * @param document XML DOM
   * @param name target name of the PIs
   * @param remove remove PIs from the DOM if the flag is true
   * @return allPIs
   * @returns vector with all PIs
   */
  public final static Vector getAllPIs(Document document, String name, boolean remove) {
    Vector pis = new Vector();

    NodeList nodelist = document.getChildNodes();
    int i = nodelist.getLength();
    for (int j = 0; j < i; j++) {
      Node node = nodelist.item(j);
      if (node.getNodeType() == Node.PROCESSING_INSTRUCTION_NODE) {
        if (((ProcessingInstruction)node).getTarget().equals(name)) {
          pis.addElement(node);
          if (remove) {
            node.getParentNode().removeChild(node);
            i--;
          }
        }
      }
    }

    return pis;
  }

  /**
   * This method returns the first PI node based on the PI target name. The PI
   * is not removed from the document. <P>
   *
   *
   *
   * @param document XML DOM
   * @param name target name
   * @return firstPI
   */
  public final static ProcessingInstruction getFirstPI(Document document, String name) {
    return getFirstPI(document, name, false);
  }

  /**
   * This method returns the first PI based on the PI target name <P>
   *
   *
   *
   * @param document XML DOM
   * @param name target name
   * @param remove remove PI from the DOM if the flag is true
   * @return firstPI
   */
  public final static ProcessingInstruction getFirstPI(Document document, String name, boolean remove) {
    ProcessingInstruction pi = null;

    NodeList nodelist = document.getChildNodes();
    int i = nodelist.getLength();
    for (int j = 0; j < i; j++) {
      Node node = nodelist.item(j);
      if (node.getNodeType() == Node.PROCESSING_INSTRUCTION_NODE) {
        if (((ProcessingInstruction)node).getTarget().equals(name)) {
          pi = (ProcessingInstruction)node;
          if (remove) {
            node.getParentNode().removeChild(node);
          }
          break;
        }
      }
    }
    return pi;
  }

  /**
   * This method returns an hashtable with all the pseudo attributes collected
   * in the document. If more PI have the same target, the attributes are all
   * put in the same hashtable. If there are collisions, the last attribute is
   * insered.
   *
   * @param document TBD: Description of the incoming method parameter
   * @param name TBD: Description of the incoming method parameter
   * @return pIPseudoAttributes
   */
  public final static Hashtable getPIPseudoAttributes(Document document, String name) {
    Hashtable attributes = new Hashtable();
    Enumeration nodes = getAllPIs(document, name).elements();
    while (nodes.hasMoreElements()) {
      ProcessingInstruction pi = (ProcessingInstruction)nodes.nextElement();
      addPIPseudoAttributes(pi, attributes);
    }
    return attributes;
  }

  /**
   * This method returns the pseudo attributes found in the first PI with the
   * given name. No validation is performed on the PI pseudo syntax <P>
   *
   *
   *
   * @param pi Processing instruction
   * @return pIPseudoAttributes
   * @returns hashtable with all pseudo attributes
   */
  public final static Hashtable getPIPseudoAttributes(ProcessingInstruction pi) {
    Hashtable attributes = new Hashtable();
    addPIPseudoAttributes(pi, attributes);
    return attributes;
  }

  /**
   * This method adds pseudo attributes from a pi to an existing attribute list.
   * All attributes are all put in the same hashtable. If there are collisions,
   * the last attribute is inserted. No validation is performed on the PI pseudo
   * syntax.
   *
   * @param pi pIPseudoAttributes to be added
   * @param attributes pIPseudoAttributes to be added
   */
  private final static void addPIPseudoAttributes(ProcessingInstruction pi, Hashtable attributes) {
    String data = pi.getData();

    StringTokenizer st = new StringTokenizer(data, "\"");
    try {
      while (st.hasMoreTokens()) {
        String key = st.nextToken();// attribute name and '='
        String token = st.nextToken();// exact attribute value
        key = key.replace('=', ' ').trim();// remove whitespace and '='
        attributes.put(key, token);
      }
    }
    catch (NoSuchElementException nsee) {
      // ignore white-space at the end of pseudo-list
      if (LOG.beDebug()) {
        LOG.debugT(nsee.getMessage());      
      }
    }
  }
}
