/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline.tools;
import com.sapportals.wcm.util.cache.*;

import java.util.Properties;
import org.w3c.dom.Document;

/**
 * WCM Pipeline interface for transformer class. <p>
 *
 * This interface must be implemented by every tool that implement XSLT
 * processing capabilites in order to be used by the WCM pipeline. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/pipeline/api/com/sapportals/wcm/service/pipeline/tools/IXsltProcessor.java#1
 *      $
 */
public interface IXslTransformer {

  /**
   * Process the XML DOM with the XSL sheet and return the result tree. <p>
   *
   *
   *
   * @param xml DOM of the XML resource
   * @param xmlPath Source path of the XML resource
   * @param xsl DOM of the XSL resource
   * @param xslPath source path of the XSL resource
   * @param result result DOM
   * @param encoding encoding of the XML resource
   * @param properties property collection
   * @param cache use that cache, otherwise set parameter to <code>null</code>
   * @return TBD: Description of the outgoing return value
   * @exception Exception Exception raised in failure situation
   */
  Document process(Document xml, String xmlPath,
    Document xsl, String xslPath,
    Document result, String encoding, Properties properties,
    ICache cache)
    throws Exception;
}
