/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline.tools;

import java.io.IOException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * WCM Pipeline interface for XML parser. <p>
 *
 * This interface must be implemented by every tool that implement XML parsing
 * capabilites in order to be used by the WCM pipeline. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/pipeline/api/com/sapportals/wcm/service/pipeline/tools/IXmlParser.java#2
 *      $
 */
public interface IXmlParser {
  /**
   * Creates a DOM tree parsing the given input source
   *
   * @param input TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   * @exception SAXException Exception raised in failure situation
   * @exception IOException Exception raised in failure situation
   */
  public Document parse(InputSource input)
    throws SAXException, IOException;

  /**
   * Creates a DOM tree parsing the given input source
   *
   * @param input TBD: Description of the incoming method parameter
   * @param validate TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   * @exception SAXException Exception raised in failure situation
   * @exception IOException Exception raised in failure situation
   */
  public Document parse(InputSource input, boolean validate)
    throws SAXException, IOException;

  /**
   * Creates an empty DOM tree.
   *
   * @return TBD: Description of the outgoing return value
   */
  public Document createEmptyDocument();
}
