/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline.producer;

import com.sapportals.wcm.*;
import com.sapportals.wcm.service.pipeline.RequestData;
import com.sapportals.wcm.util.urlcontentaccess.*;
import java.io.*;

import java.util.Date;

import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <p>
 *
 * Provides access via URL. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/pipeline/api/com/sapportals/wcm/service/pipeline/producer/ProducerFromUrl.java#5
 *      $
 */
public class ProducerFromUrl extends AbstractProducer implements IProducer {
  protected String m_url;

  /**
   * @param url TBD: Description of the incoming method parameter
   */
  public ProducerFromUrl(String url) {
    super();
    m_url = url;
  }

  public RequestData getData()
    throws WcmException {
    URLContentAccess ca = URLContentAccess.getInstance();
    try {
      IURLContent content = ca.readContent(m_url, true);
      if (content == null) {
        throw new WcmException("Error opening " + m_url);
      }
      return createRequestData(content.getInputStream(), content.getContentType());
    }
    catch (URLContentAccessException e) {
      throw new WcmException(e);
    }
  }

  public String getPath() {
    return m_url;
  }

  /**
   * There is no modifaction date
   *
   * @return lastModified
   */
  public Date getLastModified() {
    return null;
  }
}
