/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline.producer;

import com.sapportals.wcm.*;
import com.sapportals.wcm.service.pipeline.RequestData;
import com.sapportals.wcm.service.pipeline.producer.AbstractProducer;

import java.util.Date;

import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <p>
 *
 * Provides access to a XML-Strings or XML-DOM (<code>Document</code> ). If a
 * XML-Strings is used, a DOM must be generated from the string. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/pipeline/api/com/sapportals/wcm/service/pipeline/producer/ProducerFromString.java#4
 *      $
 */
public class ProducerFromString extends AbstractProducer {

  private RequestData m_data = null;

  public ProducerFromString(Document doc)
    throws WcmException {
    if (doc == null) {
      throw new WcmException("Empty document!");
    }
    m_data = new RequestData(doc);
  }

  public ProducerFromString(String xmlString)
    throws WcmException {
    m_data = new RequestData(this.createDOM(xmlString));
  }

  public RequestData getData() {
    return m_data;
  }

  public String getPath() {
    return "";
  }

  /**
   * There is no modifaction date
   *
   * @return lastModified
   */
  public Date getLastModified() {
    return null;
  }
}
