/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline.producer;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.service.pipeline.RequestData;
import com.sapportals.wcm.util.content.IContent;

import java.io.*;

import java.util.Date;

import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <p>
 *
 * Provides access to a stream. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/pipeline/api/com/sapportals/wcm/service/pipeline/producer/ProducerFromStream.java#4
 *      $
 */
public class ProducerFromStream extends AbstractProducer {
  protected InputStream m_stream = null;
  protected String m_mime;
  protected String m_url;

  public ProducerFromStream(InputStream stream, String url, String mimeType)
    throws WcmException {
    super();
    if (stream == null) {
      throw new WcmException("Empty stream");
    }
    m_stream = stream;
    m_mime = mimeType;
    m_url = url;
  }

  public RequestData getData()
    throws WcmException {
    return createRequestData(m_stream, m_mime);
  }

  public String getPath() {
    return m_url;
  }

  /**
   * There is no modifaction date
   *
   * @return lastModified
   */
  public Date getLastModified() {
    return null;
  }
}
