/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline.producer;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.service.pipeline.RequestData;
import com.sapportals.wcm.util.content.IContent;

import java.io.*;

import java.util.Date;

import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <p>
 *
 * Provides access to a resource. Because of the RID inside the resource, it is
 * possible to store the resource DOM in the pipeline cache. This could improve
 * the performance. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/pipeline/api/com/sapportals/wcm/service/pipeline/producer/ProducerFromResource.java#6
 *      $
 */
public class ProducerFromResource extends AbstractProducer {

  private IResource m_resource;

  public ProducerFromResource(IResource resource)
    throws WcmException {
    super();
    if (resource == null) {
      throw new WcmException("Missing resource!");
    }
    m_resource = resource;
  }

  public RequestData getData()
    throws WcmException {
    IContent content = m_resource.getUnfilteredContent();
    if (content == null) {
      throw new WcmException("Error reading unfiltered content: " + getPath());
    }
    return createRequestData(content.getInputStream(), content.getContentType());
  }

  public String getPath() {
    try {
      return m_resource.getRID().toString();
    }
    catch (Exception e) {
      return "";
    }
  }

  /**
   * Get the last modified date if available, null otherwise
   *
   * @return lastModified
   */
  public Date getLastModified() {
    return m_resource.getLastModified();
  }
}
