/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline.producer;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.service.pipeline.RequestData;

import java.util.Date;

/**
 * A producer prepares input data for further processing. The following
 * producers are available: <p>
 *
 *
 * <li> <code>ProducerFromResource</code> : Gets the data from a resource
 * <li> <code>ProducerFromStream</code> : Gets data from stream
 * <li> <code>ProducerFromString</code> : Gets data from string or from DOM
 * <li> <code>ProducerFromURL</code> : Gets data from URL <p>
 *
 * It is recommended to use <code>ProducerFromResource</code> whenever possible.
 * Each WCM Pipeline Producer must implement this Interface. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/pipeline/api/com/sapportals/wcm/service/pipeline/producer/IProducer.java#4
 *      $
 */
public interface IProducer {
  /**
   * This method is responsible to provide a Content object which contains the
   * XML DOM and/or a stream to non XML data;
   *
   * @return content object
   * @exception WcmException Exception raised in failure situation
   */
  public RequestData getData()
    throws WcmException;

  /**
   * Returns the path where the resource is found, or an empty string if no path
   * can be applied to the resource.
   *
   * @return resource path or empty string
   */
  public String getPath();

  /**
   * Get the last modified date of the resource if possible, otherwise it
   * returns null
   *
   * @return date or null
   */
  public Date getLastModified();
}
