/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline.processor;

import com.sapportals.wcm.service.pipeline.RequestData;

import java.util.Dictionary;

/**
 * Transforms the data provided by the producer into another form. Each WCM
 * Pipeline Processor must implement this Interface. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/pipeline/api/com/sapportals/wcm/service/pipeline/processor/IProcessor.java#3
 *      $
 */
public interface IProcessor {
  /**
   * Process this RequestData. The returned data is allowed to be either a copy
   * or the modified input data.
   *
   * @param data Request data
   * @param parameters Parameters for the processor e.g. XSL top level
   *      parameters.
   * @return result of the transfomation.
   * @exception Exception Exception raised in failure situation
   */
  RequestData process(RequestData data, Dictionary parameters)
    throws Exception;
}
