/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline.formatter;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.service.pipeline.RequestData;
import com.sapportals.wcm.util.content.*;

import java.io.*;
import java.util.*;

/**
 * The formatter generates the output format for the pipeline, e.g. the XML DOM
 * is serialized as HTML. The formatters are available: <p>
 *
 *
 * <li> JaxpSerializeFormatter: Serializes DOM
 * <li> StreamFormatter: Get identical copy (do nothing).
 * <li> FOFormatter: Transforms XSLFO data into PDF format. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/pipeline/api/com/sapportals/wcm/service/pipeline/formatter/IFormatter.java#5
 *      $
 */
public interface IFormatter {
  /**
   * Generates the output format.
   *
   * @param data request data (DOM or stream)
   * @param parameters parameter list
   * @return IContent object
   * @exception Exception Exception raised in failure situation
   */
  IContent format(RequestData data, Dictionary parameters)
    throws Exception;
}
