/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline;

import com.sapportals.wcm.*;

import java.io.InputStream;
import org.w3c.dom.Document;

/**
 * Wrapper class contains DOM (of type <code>document</code> ) or <code>
 * InputStream</code> . Allow a uniform view of request data. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/pipeline/api/com/sapportals/wcm/service/pipeline/RequestData.java#3
 *      $
 */
public class RequestData extends WcmObject {
  private Document m_document;// XML document
  private InputStream m_stream;// Stream to non-XML data
  private String m_mimeType;
  private String m_encoding;

  public RequestData() {
    this(null, null);
  }

  public RequestData(Document document) {
    this(document, null);
  }

  public RequestData(InputStream stream) {
    this(null, stream);
  }

  public RequestData(Document document, InputStream stream) {
    this(document, stream, "");
  }

  public RequestData(Document document, InputStream stream, String mime) {
    setDocument(document);
    setStream(stream);
    setMime(mime);
  }

  public RequestData(Document document, InputStream stream, String mime, String encoding) {
    this(document, stream, mime);
    setEncoding(encoding);
  }

  public void setDocument(Document document) {
    m_document = document;
  }

  public Document getDocument() {
    return m_document;
  }

  public void setStream(InputStream stream) {
    m_stream = stream;
  }

  public InputStream getStream() {
    return m_stream;
  }

  public void setMime(String mime) {
    m_mimeType = mime;
  }

  public String getMime() {
    return m_mimeType;
  }

  public void setEncoding(String encoding) {
    m_encoding = encoding;
  }

  public String getEncoding() {
    return m_encoding;
  }

  public boolean hasStream() {
    return m_stream != null;
  }

  public boolean hasDocument() {
    return m_document != null;
  }
}
