/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.service.IService;
import com.sapportals.wcm.service.pipeline.processor.IProcessor;
import com.sapportals.wcm.service.pipeline.producer.IProducer;
import com.sapportals.wcm.service.pipeline.tools.IXmlParser;
import com.sapportals.wcm.service.pipeline.tools.IXslTransformer;
import com.sapportals.wcm.util.content.IContent;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

/**
 * Interface for the WCM pipeline service. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id:$
 */
public interface IPipelineService extends IService {
  /**
   * @param producer data to transform.
   * @param defaultProcessor the default processor.
   * @param properties Properties are passed to the processor and formatter.
   *      E.g. they can be used to define additinonal XSL top level parameters.
   *      All property names starting with "wpl_" are reserved for intenal use
   *      of the WCM pipeline service!
   * @return result of the XSL transformation
   * @exception WcmException Exception raised in failure situation
   */
  public IContent handle(IProducer producer, IProcessor defaultProcessor, Hashtable properties)
    throws WcmException;

  /**
   * this method returns a tool of the PipelineService.
   *
   * @param toolName name of the tool
   * @return tool of the PipelineService
   * @exception WcmException Exception raised in failure situation
   */
  public Object getTool(String toolName)
    throws WcmException;

  /**
   * this method returns the XML Parser used by the PipelineService
   *
   * @return XML Parser
   * @exception WcmException Exception raised in failure situation
   * @see com.sapportals.wcm.service.pipeline.tools.IXmlParser
   */
  public IXmlParser getXmlParser()
    throws WcmException;

  /**
   * this method returns the XSL transfomer used by the PipelineService
   *
   * @return XSL transfomer
   * @exception WcmException Exception raised in failure situation
   */
  public IXslTransformer getXslTransformer()
    throws WcmException;

  /**
   * this method returns the configuration data von the PipelineService
   *
   * @return configuration data
   * @exception WcmException Exception raised in failure situation
   */
  public Properties getConfiguration()
    throws WcmException;
}
