/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.pipeline;

/**
 * Constant definitions for the WCM Pipeline package. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author roland.preussmann@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/pipeline/api/com/sapportals/wcm/service/pipeline/IConst.java#4
 *      $
 */
public interface IConst {
  final static String TOOL_XMLPARSER = "xmlparser";
  final static String TOOL_XSLTPROC = "xsltproc";

  final static String FORMATTER_MIME = "MIME-type";
  final static String FORMATTER_ENCODING = "encoding";
  final static String FORMATTER_DOCTYPE_PUBLIC = "doctype-public";
  final static String FORMATTER_DOCTYPE_SYSTEM = "doctype-system";
  final static String FORMATTER_INDENT = "indent";
  final static String FORMATTER_PRESERVE_SPACE = "preserve-space";
  final static String FORMATTER_LINE_WIDTH = "line-width";
  final static String FORMATTER_METHOD = "method";
  final static String FORMATTER_XML_DECL = "XMLDeclaration";

  final static String PROP_SAP = "sap_";
  final static String PROP_LANGUAGE = "sap_language";
  final static String PROP_USER = "sap_user";

  final static String PROP_WPL = "wpl_";
  final static String PROP_PATH = "wpl_path";
  final static String PROP_BROWSER = "wpl_browser";
  final static String PROP_XSL_DOM = "wpl_xsl_dom";
  final static String PROP_XSL_PROD = "wpl_xsl_prod";
  final static String PROP_XSL_PATH = "wpl_xsl_path";

  final static String WCM_PROCESS_PI = "wcm-process";
  final static String WCM_FORMAT_PI = "wcm-format";
}
