package com.inqmy.ats.system;

import java.util.*;
import java.rmi.RemoteException;
import org.w3c.dom.*;

import com.inqmy.ats.*;
import com.inqmy.ats.provider.CoreContext;
import com.sap.engine.services.security.remote.*;
import com.sap.engine.services.adminadapter.impl.ManagementInterfaceProxyFactoryImpl;
import com.sap.engine.services.adminadapter.interfaces.RemoteAdminInterface;
import com.sap.engine.services.adminadapter.interfaces.ServiceAdministrator;
import com.sap.engine.interfaces.security.userstore.context.UserContext;

public class UserEnvironmentImpl implements UserEnvironment {

  private Vector users = null;

  private Vector groups = null;

  private String root = null;

  private static final String SECURITY = "security";
  /**
   * Admin lookup constant
   */
  private static final String ADMIN = "adminadapter";

  /*
   * User manager reference
   */
   private RemoteGroupContext groupManager = null;

  /*
   * User manager reference
   */
   private RemoteUserContext userManager = null;

	private boolean toClose = false;

  public void init(Properties p) throws Exception {
    String root = CoreContext.getTestContext().getTestDir();
    this.root = root;
    users = new Vector();
    groups = new Vector();
    NamingEnvironmentImpl naming = new NamingEnvironmentImpl();
    naming.init(p);
    RemoteAdminInterface admin = (RemoteAdminInterface) naming.lookup(ADMIN);
//RK    ServiceAdministrator serviceAdmin = admin.getServiceAdministrator();
//RK    RemoteSecurity remoteSecurity = (RemoteSecurity) serviceAdmin.generateCurrentManagementInterfaceProxy(SECURITY);
    RemoteSecurity remoteSecurity = (RemoteSecurity) new ManagementInterfaceProxyFactoryImpl(naming.getContext().getEnvironment()).generateCurrentManagementInterfaceProxy(SECURITY, RemoteSecurity.class);
//KR
    RemoteUserStore store = remoteSecurity.getRemoteUserStoreFactory().getActiveUserStore();
    userManager = store.getUserContext();
    groupManager = store.getGroupContext();
  }

  public UserEnvironmentImpl() throws Exception {
  }

  public void createUser(String name, String password, String[] parentGroups) throws SecurityException ,RemoteException {
    RemoteUserStoreInfo rusi = userManager.createUser(name);
    rusi.writeUserProperty(9, password.toCharArray());
    for (int i = 0 ; i < parentGroups.length ; i++){
      groupManager.addUserToGroup(name , parentGroups[i]);
    }
		if(!users.contains(name)) {
      users.add(name);
		}
  }

  public void createGroup(String name, String[] parentGroups) throws SecurityException , RemoteException {
    groupManager.createGroup(name);
    if(!groups.contains(name)){
      groups.add(name);
    }
    for (int i = 0 ; i < parentGroups.length ; i++){
      groupManager.addGroupToParent(name , parentGroups[i]);
    }
  }

  public void group(String item, String group, boolean isUser) throws SecurityException , RemoteException{
    if(isUser) {
      groupManager.addUserToGroup(item , group);
    } else {
      groupManager.addGroupToParent(item , group);
    }
  }

  public void ungroup(String item, String group, boolean isUser) throws SecurityException , RemoteException{
    if(isUser) {
      groupManager.removeUserFromGroup(item , group);
    } else {
      groupManager.removeGroupFromParent(item , group);
    }
  }

  public int getUserId(String name, boolean user) throws SecurityException , RemoteException {
//    return userManager.getUserId(name, user);
    return 0;
  }

  public void create(String users) throws Exception {
    throw new Exception("Deprecated!");
/*
    StandardDOMParser parser = new StandardDOMParser();
    parser.setValidation(true);
    Document doc = parser.parse(users);
    Element element = doc.getDocumentElement();
    NodeList nodes = element.getChildNodes();
    for(int index = 0; index < nodes.getLength(); index++) {
      Node node = nodes.item(index);
      short nodetype = node.getNodeType();
      if((nodetype == Node.ELEMENT_NODE ) && (node.hasChildNodes())) {
        if(node.getNodeName().equals("group")) {
          createGroup(node);
        } else if(node.getNodeName().equals("user")) {
          createUser(node, null);
        }
      }
    } */
  }

  public void removeUser(String name) throws SecurityException, RemoteException {
    userManager.deleteUser(name);
    users.remove(name);
  }

  public void removeGroup(String name) throws SecurityException , RemoteException{
    groupManager.deleteGroup(name);
    groups.remove(name);
  }

  public void close() throws Exception {
		if (!toClose) {
      toClose = true;
			for(int i = 0; i < users.size(); i++) {
				userManager.deleteUser((String) users.get(i));
			}
      for(int i = 0; i < groups.size(); i++) {
        String groupName = (String) groups.get(i);
        RemoteIterator childrenUsers =  groupManager.getUsersOfGroup(groupName);
        RemoteIterator childrenGroups = groupManager.getChildGroups(groupName);
        while(childrenUsers.hasNext()) {
          String user = (String) childrenUsers.next();
          groupManager.removeUserFromGroup(user, groupName);
        }
        while(childrenGroups.hasNext()) {
          String child = (String) childrenGroups.next();
          groupManager.removeGroupFromParent(child, groupName);
        }
        groupManager.deleteGroup(groupName);
      }
    }
  }

  private void createGroup(Node node) throws RemoteException , SecurityException{
/*    String groupName = null;
    String[] parentArray = null;
    String[] userArray = null;
    String[] childrenArray = null;
    Vector parents = new Vector();
    Vector users = new Vector();
    Vector childrens = new Vector();
    Vector nodes = new Vector();
    NodeList childNodes = node.getChildNodes();
    for(int i = 0; i < childNodes.getLength(); i++) {
      Node groupNode = childNodes.item(i);
      if(groupNode.getNodeName().equals("group-name")) {
        groupName = groupNode.getFirstChild().getNodeValue();
      } else if(groupNode.getNodeName().equals("parent-group")) {
        parents.add(groupNode.getFirstChild().getNodeValue());
      } else if(groupNode.getNodeName().equals("children-group")) {
        childrens.add(groupNode.getFirstChild().getNodeValue());
      } else if(groupNode.getNodeName().equals("exist-user")) {
        users.add(groupNode.getFirstChild().getNodeValue());
      } else if(groupNode.getNodeName().equals("user")) {
        nodes.add(groupNode);
      }
    }
    parentArray = new String[parents.size()];
    userArray = new String[users.size()];
    childrenArray = new String[childrens.size()];
    parents.copyInto(parentArray);
    users.copyInto(userArray);
    childrens.copyInto(childrenArray);
    createGroup(groupName, parentArray);
    for(int i = 0; i < userArray.length; i++) {
      userManager.groupUser(true, userArray[i], groupName);
    }
    for(int i = 0; i < childrenArray.length; i++) {
      userManager.groupUser(false, childrenArray[i], groupName);
    }
    for(int i = 0; i < nodes.size(); i++) {
      createUser((Node) nodes.get(i), groupName);
    }
*/
  }

  private void createUser(Node node, String parentName) throws SecurityException , RemoteException {
/*    String userName = null;
    String userPassword = null;
    String[] parentsGroup = null;
    Vector parents = new Vector();
    if(parentName != null) {
      parents.add(parentName);
    }
    NodeList childNodes = node.getChildNodes();
    for(int i = 0; i < childNodes.getLength(); i++) {
      Node userNode = childNodes.item(i);
      if(userNode.getNodeName().equals("user-name")) {
        userName = userNode.getFirstChild().getNodeValue();
      } else if(userNode.getNodeName().equals("user-password")) {
        userPassword = userNode.getFirstChild().getNodeValue();
      } else if(userNode.getNodeName().equals("parent-group")) {
        parents.add(userNode.getFirstChild().getNodeValue());
      }
    }
    parentsGroup = new String[parents.size()];
    parents.copyInto(parentsGroup);
    createUser(userName, userPassword, parentsGroup);
*/
  }

}