package com.inqmy.ats.system;

import java.util.*;
import java.io.*;

import com.inqmy.ats.*;
import com.inqmy.ats.provider.CoreContext;

final class TestEnvironmentImpl implements TestEnvironment {
  
  private String rootDir = null;
  private String propertiesName = null;
  private Properties defaultProperties = null;
	private FileInputStream in = null;

	private boolean toClose = false;
  
  public void init(Properties defaultProperties) throws Exception {
    String rootDir = CoreContext.getTestContext().getTestDir();
    this.rootDir = rootDir;
    this.propertiesName = propertiesName;
    this.defaultProperties = defaultProperties;
  }
  
  public TestEnvironmentImpl() {
  }
  
  public String getRootDir() {
    return(rootDir);
  }
  
  public Properties getProperties() {
    return((Properties)defaultProperties.clone());
  }
  
  public Properties getProperties(String name) {
    return(createProperties(name));
  }
  public String getCommonTestClassPath() {
    return CoreContext.getTestsClassPath();
  }
	public InputStream getFileInputStream(String fileName) throws IOException {
		try {
			if (in != null) {
				 in.close();
			}
		} catch(Exception e) {}
		try {
			 in = new FileInputStream( rootDir + File.separator + fileName.replace('/', File.separatorChar).replace('\\', File.separatorChar) );
			 return in;
		} catch(Exception exc) {
//			exc.printStackTrace();
			throw new IOException(exc.toString());
		}
	}
  
  public File getFile(String fileName) throws IOException {
		return new File(rootDir + File.separator + fileName.replace('/', File.separatorChar).replace('\\', File.separatorChar));
	}

  public void setTimeout(long timeout) throws Exception {
    CoreContext.getTestContext().setTestTimeout(timeout*60*1000);
  }


  private Properties createProperties(String propertiesName) {
    Properties result = new Properties();
    try {
      FileInputStream propertyInput = new FileInputStream(rootDir + File.separator + propertiesName);
      result.load(propertyInput);
      propertyInput.close();
    } catch(IOException ioExc) {
      if(ioExc instanceof FileNotFoundException) {
        throw new RuntimeException("Property with name " + propertiesName + " missing");
      }
    }
    return(result);
  }
  
  public void close() {
		if(!toClose){
			toClose = true;
			try {
				if (in != null) {
					in.close();
				}
			} catch(Exception ex) {
				ex.printStackTrace();
			}
		}
  }
}