/**
 * Copyright (c) 2002 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 */
package com.inqmy.ats.system;

import com.inqmy.ats.ShellEnvironment;

import java.util.Properties;
import java.util.Vector;
import java.util.StringTokenizer;
import java.util.HashSet;
import java.io.*;
import java.net.*;

/**
 *
 * @author Vencislav Dimitrov
 */
public class ShellEnvironmentImpl implements ShellEnvironment {
  public static final String PROMPT = "\005";
  public static final byte PROMPT_BYTE = 5;
  private int[] dispatcherIDs;
  private int[] serverIDs;

  private HashSet visitNodes = new HashSet();

  private Socket socket;
  private InputStream telnetIS;
  private OutputStream telnetOS;

  //private OutputStream dumpStream;





  ////////////////////////////////
  // Environment Interface
  ////////////////////////////////
  public void init(Properties p) throws Exception {
    connect(p);
    initIDs();
  }

  public void close() throws Exception {
    try {
      telnetIS.close();
    } catch (IOException ioEx) {
      ioEx.printStackTrace();
    }
    try {
      telnetOS.close();
    } catch (IOException ioEx) {
      ioEx.printStackTrace();
    }
    try {
      socket.close();
    } catch (IOException ioEx) {
      ioEx.printStackTrace();
    }

    /*try {
      dumpStream.close();
    } catch (IOException ioEx) {
      ioEx.printStackTrace();
    }
    */
  }


  ////////////////////////////////
  // ShelEnv Interface
  ////////////////////////////////
  public String execCommand(String line) throws Exception {
    String trash = readAvailable();
    if (trash.length() > 0) {
      dump("============ error =============\n".getBytes());
      dump(trash.getBytes());
      dump("================================\n".getBytes());
    }
    sendToServer(line);
    if (line.toLowerCase().trim().startsWith("jump")) {
      try {
        int id = Integer.parseInt(line.substring(5).trim());
        // TODO return line +"\n" + jump(id);
        return jump(id);
      } catch (NumberFormatException nfEx) {
        nfEx.printStackTrace();
      }
    }
    // TODO return line +"\n" + readToPrompt();
    return readToPrompt();
  }

  public String[] execScript(String file) throws Exception {
    String[] result = null;
    Vector vec = new Vector();
    BufferedReader reader = new BufferedReader(new FileReader(file));
    String command = null;
    while((command = reader.readLine()) != null) {
      vec.add(execCommand(command.trim()));
    }
    result = new String[vec.size()];
    vec.copyInto(result);
    return result;
  }

  public int[] getDispatcherIds() {
    return dispatcherIDs;
  }

  public int[] getServerIds() {
    return serverIDs;
  }


  ////////////////////////////////
  // private methods
  ////////////////////////////////
  private void connect(Properties p)  throws Exception {
    /*
    try {
      File ff = File.createTempFile(this.toString() +"_" , "_log.log" , new File("."));
      dumpStream = new FileOutputStream(ff);
    } catch (IOException ioEx) {
      ioEx.printStackTrace();
    }
      */
    int port = Integer.parseInt(p.getProperty("telnet_port", "50008").trim());
    String host = p.getProperty("server_host", "localhost").trim();

    socket = new Socket(host, port);
    telnetIS = socket.getInputStream();
    telnetOS = socket.getOutputStream();
    readToString("Login:");
    sendToServer(p.getProperty( "server_user" ,"Administrator").trim());
    readToString("Password:");
    sendToServer(p.getProperty( "server_password" ,"sap").trim());
    readToString(">");
    echoOff();
    readClearPrompt();
    setPrompt();
  }

  private void initIDs() throws Exception {
    String _79 = "-------------------------------------------------------------------------------";
    Vector servers = new Vector(6);
    Vector dispatchers = new Vector(3);

    String ls = execCommand("lsc");

    int index = ls.indexOf(_79);
    StringTokenizer tokenizer = new StringTokenizer(ls.substring(index + _79.length()) , _79);
    while(tokenizer.hasMoreTokens()) {
      String token = tokenizer.nextToken().trim();
      String id = null;
      index = token.indexOf("\n");
      if( index != -1) {
        id = token.substring(index).trim();
        id = id.substring(0,id.indexOf(" ")).trim();
      } else {
        id = token.substring(13).trim();
        id = id.substring(0 , id.indexOf(" ")).trim();
      }
      if(token.indexOf("dispatcher") != -1) {//dispatcher id
        dispatchers.add(id);
      }
      if(token.indexOf("server") != -1) {//server id
        servers.add(id);
      }

    }
    dispatcherIDs = new int[dispatchers.size()];
    serverIDs = new int[servers.size()];
    for(int i = 0; i < dispatcherIDs.length; i++) {

      dispatcherIDs[i] = Integer.parseInt((String) dispatchers.get(i));
    }
    for(int i = 0; i < serverIDs.length; i++) {
      serverIDs[i] = Integer.parseInt((String) servers.get(i));
    }

    visitNodes.add(dispatcherIDs[0] + "");
  }

  private void sendToServer(String text) throws IOException {
    text += "\n";
    telnetOS.write(text.getBytes("ISO8859-1"));
    telnetOS.flush();
    dump(("<CMD> " + text).getBytes("ISO8859-1"));
  }

  private void echoOff() throws IOException {
    telnetOS.write(0);
    telnetOS.write(8);
    telnetOS.flush();
  }

  private String readAvailable() throws IOException {
    return waitAndReadAvailable(0);
  }

  private String waitAndReadAvailable(int timeout) throws IOException {
    try {
      Thread.sleep(timeout);
    } catch (InterruptedException inEx) {
      inEx.printStackTrace();
    }
    int size = telnetIS.available();
    if (size > 0) {
      byte[] buff = new byte[size];
      telnetIS.read(buff);
      dump(buff);
      return new String(buff);
    } else {
      return "";
    }
  }

  private void setPrompt() throws IOException {
    String promptCommand = "SET $PROMPT=\"" + PROMPT + "\"";
    sendToServer(promptCommand);
    readToPrompt();
    readAvailable();
  }

  private String readToString(String text) throws IOException {
    StringBuffer buffer = new StringBuffer();
    byte[] ch = new byte[1];
    while (true) {
      int size = telnetIS.read(ch);
      dump(ch);
      if (size < 0) {
        break;
      }
      buffer.append(new String(ch));
      if (buffer.toString().endsWith(text)) {
        break;
      }
    }
    return buffer.toString().trim();

  }

  private String readToPrompt() throws IOException {
    StringBuffer buffer = new StringBuffer();
    byte[] ch = new byte[1];
    while (true) {
      int size = telnetIS.read(ch);
      dump(ch);
      if (size < 0 || ch[0] == PROMPT_BYTE) {
        break;
      }
      buffer.append(new String(ch));
    }
    return buffer.toString().trim();
  }

  private String readClearPrompt() throws IOException {
    String res = "";
    while (true) {
      res += waitAndReadAvailable(100);
      sendToServer("");
      res += waitAndReadAvailable(100);
      res.trim();
      if (res.endsWith(">")) {
        break;
      }
    }
    return res;
  }

  private String jump(int clusterID) throws IOException {
    if (!visitNodes.contains(clusterID + "")) {
      visitNodes.add(clusterID + "");
      dump(("=============== JUMP TO " + clusterID + " =================\n").getBytes("ISO8859-1"));
      String res = readClearPrompt();
      echoOff();
      setPrompt();
      return res + readAvailable();
    }

    return readToPrompt();
  }

  private void dump(byte[] message) throws IOException {
    //dumpStream.write(message);
    //dumpStream.flush();
  }
}
