package com.inqmy.ats.system;

import java.util.*;
import com.inqmy.ats.*;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.CommunicationServiceContext;

/**
 * This class is the factory of environments that test which implements interface com.inqmy.ats.ServerTest can use.
 */
public final class ServiceEnvironmentFactory {
  /**
   * Id of LogEnvironment.
   */
  public final static int LOG = 1;
  /**
   * Id of TestEnvironment.
   */
	public final static int TEST = 2;
  
  public static ServiceContext scontext;
	private static Vector testsEnv;
  /**
   * Returns Environment implementation with given id and passes to it default system properties.
   *
   * @param env        id of environment.
   * @return           Environment implementation.
   * @throws Exception if error occurs.
   */
  public static Environment getEnvironment(int env) throws Exception {
    Environment result = null;
    switch(env) {
      case LOG : {
        if (scontext instanceof CommunicationServiceContext) {
          result = (Environment)(Class.forName("com.inqmy.ats.system.dispimpl.impl.LogEnvironmentImpl").newInstance());
        } else {
          result = (Environment)(Class.forName("com.inqmy.ats.system.serverimpl.impl.LogEnvironmentImpl").newInstance());
        }
        break;
      } 
			case TEST : {
				if (testsEnv == null){
					testsEnv = new Vector();
				}
        if (scontext instanceof CommunicationServiceContext) {
          result = (Environment)(Class.forName("com.inqmy.ats.system.dispimpl.impl.TestEnvironmentImpl").newInstance());
        } else {
          result = (Environment)(Class.forName("com.inqmy.ats.system.serverimpl.impl.TestEnvironmentImpl").newInstance());
        }
				testsEnv.add(result);
				break;
			}
      default:{
        throw new Exception("   We don't support this environment");
      }
    }
    return result;
  }
  /**
   * Returns com.sap.engine.frame.ServiceContext.
   *
   * @return ServiceContext
   */
  public static ServiceContext getServiceContext() {
    return scontext;
  }

	/**
  * Closes all environments instances which are took from factory.
  * This method is called automatically after execution of all methods of a given test class.
  */
  public static void close(){
		if (testsEnv != null){
			Environment t = null;
      for(int i = 0 ; i < testsEnv.size() ; i++ ){
			  try {
          t = (Environment)testsEnv.get(i);
					t.close();
			  } catch(Exception e){
			  	System.out.println("[ATSERVICE : testEnvironemnt ERROR]"+e.toString()+" ERROR closing environment : " );
			  }
		  }
			testsEnv = null;
		}
	}
  
 
}