package com.inqmy.ats.system;

import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;
import com.sap.engine.frame.client.ClientFactory;

import com.inqmy.ats.*;

public class NamingEnvironmentImpl implements NamingEnvironment {

  private Properties adminProperties = null;

  private Context adminContext = null;

  private boolean toClose = false;


  public void init(Properties p) throws Exception {
    String adminUser = p.getProperty("server_user", "Administrator").trim();
    String password = p.getProperty("server_password", "").trim();
    String host = p.getProperty("server_host", "localhost").trim();
    String factory = p.getProperty("naming_factory", "com.sap.engine.services.jndi.InitialContextFactoryImpl").trim();
    String transportType = p.getProperty("transport_type" , "None").trim();
    if ( host.indexOf(":") == -1 ){
      String port = null;
      if (transportType.equals("None")) {
        port = p.getProperty("p4normal_port");
      } else if(transportType.equals("ssl")){
        port = p.getProperty("ssl_port");
      } else if(transportType.equals("httptunneling")){
        port = p.getProperty("httptunneling_port");
      }
      if(port != null) host += ":" + port;
    }
    adminProperties = new Properties();
    adminProperties.put("TransportLayerQueue", transportType);
    adminProperties.put(Context.INITIAL_CONTEXT_FACTORY, factory);
    adminProperties.put(Context.PROVIDER_URL, host);
    adminProperties.put(Context.SECURITY_PRINCIPAL, adminUser);
    adminProperties.put(Context.SECURITY_CREDENTIALS, password);
  }

  public NamingEnvironmentImpl() {

  }

  public Context getContext(String user, String password) throws NamingException {
    Properties userProperties = (Properties) adminProperties.clone();
    userProperties.put(Context.SECURITY_PRINCIPAL, user);
    userProperties.put(Context.SECURITY_CREDENTIALS, password);
    InitialContext ic = new InitialContext(userProperties);
    setContextObject();
    return ic;
  }

  public Context getContext() throws NamingException {
    InitialContext ic = new InitialContext(adminProperties);
    setContextObject();
    return ic;
  }

  public DirContext getDirContext(String user, String password) throws NamingException {
    Properties userProperties = (Properties) adminProperties.clone();
    userProperties.put(Context.SECURITY_PRINCIPAL, user);
    userProperties.put(Context.SECURITY_CREDENTIALS, password);
    InitialDirContext idc = new InitialDirContext(userProperties);
    setContextObject();
    return idc;
  }

  public DirContext getDirContext() throws NamingException {
    InitialDirContext idc = new InitialDirContext(adminProperties);
    setContextObject();
    return idc;
  }

  public Object lookup(String lookupName) throws NamingException {
    if(adminContext == null) {
      adminContext = new InitialContext(adminProperties);
      setContextObject();
    }
    Object result = null;
    synchronized(adminContext) {
      result = adminContext.lookup(lookupName);
    }
    return result;
  }

  public void close() throws Exception {
    if(!toClose){
      toClose = true;
      if(adminContext != null) {
        adminContext.close();
      }
    }
  }

  private void setContextObject() {
    try {
      com.inqmy.ats.provider.CoreContext.setContextObject(ClientFactory.getThreadContextFactory().getThreadContext().getContextObject("security"));
    } catch(Exception n) {
      n.printStackTrace();
    }
  }

}
