package com.inqmy.ats.system;

import java.util.*;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.GZIPInputStream;
import java.io.*;
import java.net.*;
import com.inqmy.ats.HttpEnvironment;
import com.inqmy.ats.LogEnvironment;
import com.inqmy.ats.HttpException;
import com.inqmy.ats.provider.TestContext;
import com.inqmy.ats.system.EnvironmentFactory;
import com.inqmy.ats.system.DefaultComparator;
import com.inqmy.ats.system.tools.Utilities;
import com.inqmy.ats.provider.CoreContext;

public class HttpEnvironmentImpl implements HttpEnvironment {

  protected static final String[] method = new String[] {"GET", "PUT", "POST", "HEAD", "DELETE", "OPTIONS", "TRACE"};

  private static final String[] HEADERS_ARRAY = new String[]{"INFO" , "WARNING" , "ERROR"};

  public static final byte INFO = 0;
  public static final byte WARNING = 1;
  public static final byte ERROR = 2;

  protected String host = null;

  protected int port = -1;

  private byte[] bodyResp;

  private Vector headersResp = new Vector();

  private Hashtable responseHash = new Hashtable();

  private Hashtable cookies = new Hashtable();

  protected BufferedReader requests = null;

  protected Properties p = null;

  protected String outputFile = null;

  protected String connection_type = null;

  protected String host_port = null;

  protected String actual_cookie = null;

  protected String[] errors = null;

  protected int delay = -1;

  protected Socket socket = null;

  protected InputStream is = null;

  protected OutputStream os = null;

  protected StringBuffer buffer = new StringBuffer(4096);

  protected StringBuffer small_buffer = new StringBuffer(512);

  protected boolean connection = false;

  protected long time = -1;

  private LogEnvironment log = null;

  private String dirForResponse = null;
  private String dirForResponseName = null;
  private String relativePathForResponse = null;
  //private FileOutputStream internalLog;

	private boolean toClose = false;

	private boolean isInit = false;

  private boolean toParseCookie = true;

  private boolean authenticate = false;

  private final String linelogSeparator = "------------------------------------------";
  private boolean errorInHttp = false;
  private File httpLogFile;

  private int socketTimeout;

  public void init(Properties env) throws Exception {
    this.p = env;
    try {
      socketTimeout = Integer.parseInt(env.getProperty("http_socket_timeout").trim()) * 60 *1000;
    } catch(Exception exc) {
      socketTimeout = 2*60*1000;
      System.out.println("Http Environment will use default value for socket read timeout : " + socketTimeout/(60*1000));
    }
  }

	private void initialize() {
    TestContext test = com.inqmy.ats.provider.CoreContext.getTestContext();
    StringBuffer buf = new StringBuffer(150);
    buf.append(test.getLogDir()).append(File.separator).append(test.getTestClassLogName()).append(".").append(test.getCurrentMethodName());
    String forHttpInternalLog  = buf.toString();
    buf.append(".Status.txt");
    forHttpInternalLog += ".HttpErrorLog.txt";
    errorInHttp = false;
    try {
      httpLogFile = new File(forHttpInternalLog);
      File parent = httpLogFile.getParentFile();
      if(!parent.exists()) {
        parent.mkdirs();
      }
      //httpErrorLink = parent.getName() + "/" + httpLogFile.getName();
//      internalLog = new FileOutputStream(httpLogFile);
    } catch(Exception exc) {
      exc.printStackTrace();
//      internalLog = null;
    }

    outputFile = buf.toString();
    try {
      log = (LogEnvironment)EnvironmentFactory.getEnvironment(EnvironmentFactory.LOG);
    } catch(Exception e) {
      e.printStackTrace();
    }
    dirForResponse = test.getLogDir();
    try {
      File f = File.createTempFile( "http" , "responses" , new File(dirForResponse));
      dirForResponse = f.getCanonicalPath();
      dirForResponseName = f.getName();
      f.delete();
    } catch(Exception ex) {
      ex.printStackTrace();
      dirForResponse = null;
      dirForResponseName = null;
    }

    this.host = p.getProperty("server_host" ,"localhost").trim();
    this.port = Integer.parseInt(p.getProperty("http_port" , "80").trim());
    this.host_port = host + ":" + port;
    this.toParseCookie = (Boolean.valueOf(p.getProperty("http_toChangeCookie" , "true").trim())).booleanValue();
    StringTokenizer tokenizer = new StringTokenizer(p.getProperty("errors_strings",""), ";");
    errors = new String[tokenizer.countTokens()];
    int i = 0;
    while (tokenizer.hasMoreTokens()) {
      errors[i] = tokenizer.nextToken();
      i++;
    }
    connection_type = p.getProperty("keep_alive","false").trim();

    try {
     delay = Integer.parseInt(p.getProperty("request_delay_time","0").trim());
    } catch(Exception e) {
      e.printStackTrace();
    }
    isInit = true;
	}

  public HttpEnvironmentImpl() {
  }

  public void close() throws Exception {
		if(!toClose){
			toClose = true;
			if( socket != null) {
				try{
				socket.close();
				} catch(Exception e){}
			}
			if( is != null) {
				try{
					is.close();
				} catch(Exception e){}
			}
			if( os != null) {
				try {
					os.close();
				} catch(Exception e){}
			}
		}
  }

  public int check() throws IOException ,HttpException {
    authenticate = false;
		try{
			if (!isInit) {
				initialize();
			}
		} catch(Exception exc){
			throw new IOException("Error initializing environment" + exc.toString());
		}
    errorInHttp = false;//intialize flag for http errors
    String requestsFile = CoreContext.getTestContext().getTestDir() +  File.separator + p.getProperty("requests_file", "http_requests.txt").trim();
    this.requests = new BufferedReader(new FileReader(requestsFile));
    this.socket = new Socket(host, port);
    socket.setSoTimeout(socketTimeout);
    this.is = socket.getInputStream();
    this.os = socket.getOutputStream();
    String req = getRequest();
		//req == null means no request will be send
		if (req == null) {
		  IOException ioexc = new IOException("There is no request in request file!May be file is empty or request is not proper!");
			log.log(ioexc);
			throw ioexc;
		}
    while( req != null ) {
      try {
        getResult(req, connection_type.equals("false"));
      } catch(IOException ioexc) {
        logHttp("IOException occurs!" , ioexc , ERROR);
      }
			req = getRequest();
    }
    int iii = (new DefaultComparator(errors)).compare(outputFile, null);
    if(errorInHttp) {
      throw new HttpException("Error requests!" , new Integer(iii));
    }
    return iii;
  }

  public int check(Comparator comparator , Object secondParameter) throws IOException , HttpException {
    authenticate = false;
		try{
			if (!isInit) {
				initialize();
			}
		}catch(Exception exc){
			throw new IOException("Error initializing environment" + exc.toString());
		}
    errorInHttp = false;//intialize flag for http errors
    String requestsFile = CoreContext.getTestContext().getTestDir() +  File.separator + p.getProperty("requests_file", "http_requests.txt").trim();
    this.requests = new BufferedReader(new FileReader(requestsFile));
    this.socket = new Socket(host, port);
    socket.setSoTimeout(socketTimeout);
    this.is = socket.getInputStream();
    this.os = socket.getOutputStream();
    String req = getRequest();
		//req == null means no request will be send
		if (req == null) {
		  IOException ioexc = new IOException("There is no request in request file!May be file is empty or request is not proper!");
			log.log(ioexc);
			throw ioexc;
		}
    while( req != null) {
      try {
        getResult(req, connection_type.equals("false"));
      } catch(IOException ioexc) {
        logHttp("IOException occurs!" , ioexc , ERROR);
      }
			req = getRequest();
    }
    int iii =  comparator.compare(outputFile, secondParameter);
    if(errorInHttp) {
      throw new HttpException("Error requests!" , new Integer(iii));
    }

    return iii;
  }

  protected String getRequest() throws IOException {
    String result = null;
    buffer.delete(0, buffer.length());
    String line = requests.readLine();
    while(!checkRequestEnd(line)) {
      buffer.append(line);
      buffer.append("\r\n");
      line = requests.readLine();
    }
    result = buffer.toString();
    return result.equals("") ? null : result;
  }

  protected boolean checkRequestEnd(String line) {
    boolean result = false;
    if(line == null) {
      result = true;
    } else {
      result = line.startsWith("delay_time: ");
      if(result) {
        time = Long.parseLong(line.substring("delay_time: ".length()));
      }
    }
    return result;
  }

  protected String getResponseFileName(String request) {
    String result = null;
    int i1 = -1;
    int i2 = -1;
    int m = getRequestMetodIndex(request);
    String s1 = method[m];
    String s2 = " HTTP";
    i1 = s1.length() + 1;
    i2 = request.indexOf(s2, i1);
    result = request.substring(i1, i2);
    int indexx = result.indexOf(";");
    if(indexx != -1) {
      result = result.substring(0 , indexx);
    }
    if(result.equals("*")) {
      result = "asterisk";
    }
    if(result.startsWith("http://")) {
      int s = result.indexOf('/', "http://".length());
      result = result.substring(s);
    }
    if(result.equals("/")) {
      result = result + "index";
    }
    int q = result.indexOf('?');
    if(q != -1) {
      result = result.substring(0, q);
    }
    int d = result.indexOf('.');
    if(d == -1) {
      result = result + ".html";
    }

    result = result.replace('/'  ,File.separatorChar);

    return escapeCharacters(result);
    /*
    int ind = result.lastIndexOf(File.separatorChar);
    if(ind != -1) {
      if (ind + 1 == result.length()) {
        return  result;
      } else {
        return (result.substring(0 , ind+1) + escapeCharacters(result.substring(ind + 1)));
      }
    } else {
      return escapeCharacters(result);
    }
    */
  }

  private String escapeCharacters(String str) {
    StringBuffer sbuf = new StringBuffer();
    char[] chars = str.toCharArray();
    for (int i = 0 ; i < chars.length ; i++) {
      char symbol = chars[i];
      //a-z ; A-Z ; ' ' ; '$' ; '.' ; File.separatorChar
      if(symbol == 46 || symbol == 32 || symbol == 36 || (symbol >= 65 && symbol <= 90) || (symbol >= 97 && symbol <= 122) || symbol == File.separatorChar) {
        sbuf.append(symbol);
      }
    }
    return sbuf.toString();
  }

  protected int getRequestMetodIndex(String request) {
    int result = -1;
    for(int i = 0; i < method.length; i++) {
      if(request.startsWith(method[i])) {
        result = i;
        break;
      }
    }
    return result;
  }

  protected String requestModifier(String request, boolean mode) {
    String result = null;
    buffer.delete(0, buffer.length());
    buffer.append(request);
    int start = 0;
    int end = 0;
    String line = null;
    do {
      line = readLine(buffer, start);
      end = start + line.length();
      if(skip(line)) {
        line = "";
        buffer.replace(start, end + 2, line);
      } else {
        line = modifyLine(line, mode);
        buffer.replace(start, end, line);
      }
      start = start + line.length() + 2;
    } while(!line.equals(""));
    result = buffer.toString();
    return result;
  }

  protected String readLine(StringBuffer buf, int start) {
    String result = null;
    int current = start;
    while(buf.charAt(current) != '\r') {
      current++;
    }
    result = buf.substring(start, current);
    return result;
  }

  protected boolean skip(String line) {
    return  (line.toLowerCase().startsWith("date"));
  }

  protected String modifyLine(String line, boolean mode) {
    String result = line;
    String lineToLowerCase = line.toLowerCase();
    if(lineToLowerCase.startsWith("referer")) {
      result = modifyReferer(result);
    } else if(lineToLowerCase.startsWith("host")) {
      result = modifyHost(result);
    } else if(lineToLowerCase.startsWith("cookie")) {
      result = modifyCookie(result);
    } else if(mode && lineToLowerCase.startsWith("connection")) {
      result = modifyConnection(result);
    } else if(lineToLowerCase.startsWith("get ") || lineToLowerCase.startsWith("put ") || lineToLowerCase.startsWith("post ")) {
      result = modifyCookieInHeader(result);
    } else if(lineToLowerCase.startsWith("authorization: basic") && authenticate) {
      result = modifyBasicAuthorization(result);
    }
    return result;
  }

  protected String modifyBasicAuthorization(String line) {
    if(!authenticate) return line;
    int index = "authorization: basic".length();
    String encoded = null;
    String user = p.getProperty("server_user","Administrator").trim();
    String pass = p.getProperty("server_password","").trim();
    try {
      encoded = new String(com.sap.engine.lib.security.Base64.encode((user + ":" +pass).getBytes()));
      return line.substring(0 , index + 1) + encoded;
    } catch (Exception exc) {
      System.out.println("Error in encoding user and password for authentication");
      exc.printStackTrace();
      return line;
    }
  }

  protected String modifyCookieInHeader(String line) {
    if(!this.toParseCookie) {
      //no modify
      return line;
    }
    int firstIndexOfSpace = line.indexOf(' ');
    int lastIndexOfSpace = line.lastIndexOf(' ');
    String result = line.substring(firstIndexOfSpace , lastIndexOfSpace);
    int indexOfq = result.indexOf("?");
    int indexOfdc = result.indexOf(";");
    if(indexOfdc != -1) {
      if(!(indexOfq != -1&&(indexOfq < indexOfdc))) {
        String cook = null;
        if(indexOfq != -1) {
          cook = result.substring(indexOfdc + 1 , indexOfq);
        } else {
          cook = result.substring(indexOfdc + 1);
        }
        updateCookie(cook);
        String temp = actual_cookie.toLowerCase();
        //String temp2 = actual_cookie;
        int indexOfJSID = temp.indexOf("jsessionid");
        if(indexOfJSID != -1) {
          StringBuffer sbuf = new StringBuffer();
          int beginIndex = 0;
          while(true) {
            sbuf.append(actual_cookie.substring(beginIndex , indexOfJSID));
            sbuf.append("jsessionid");
            beginIndex = indexOfJSID + "jsessionid".length();
            indexOfJSID = temp.indexOf("jsessionid" , indexOfJSID + 1);
            if(indexOfJSID == -1) {
              sbuf.append(actual_cookie.substring(beginIndex));
              break;
            }
          }
          temp = sbuf.toString();
        }
        small_buffer.delete(0 , small_buffer.length());
        small_buffer.append(line.substring(0 , firstIndexOfSpace));
        small_buffer.append(result.substring(0 , indexOfdc +1));
        char lastChar = 0;
        for(int y = 0 ; y < temp.length();y++) {
          char ch = temp.charAt(y);
          if(ch != ' ') {
            small_buffer.append(ch);
          } else {
            if(y != 0 && lastChar != ';') {
              small_buffer.append(ch);
            }
          }
          lastChar = ch;
        }
        if( indexOfq != -1) {
          small_buffer.append(result.substring(indexOfq));
        }
        small_buffer.append(line.substring(lastIndexOfSpace));
        return small_buffer.toString();
      }
    }
    //no modify
    return line;
  }
  //called to put in cookie hashtable cookies that are only in client request but is not set by server
  private void updateCookie(String cookie) {

    StringTokenizer tokenizer = new StringTokenizer(cookie , ";");
    while(tokenizer.hasMoreTokens()) {
      String token = tokenizer.nextToken();
      int ind = token.indexOf("=");
      String key = token.substring(0,ind).trim();
      if(key.equals("jsessionid")) {
        key = key.toUpperCase();
      }
      String value = (String)cookies.get(key);
      if(value == null) {
        cookies.put(key , token.substring(ind + 1));
        if(actual_cookie == null) {
          actual_cookie = token;
        } else {
          actual_cookie+=";" + token;
        }
      }
    }

  }
  protected String modifyReferer(String s) {
    String result = null;
    small_buffer.delete(0, small_buffer.length());
    int i1 = s.indexOf('/');
    int i2 = s.indexOf('/', i1 + 2);
    small_buffer.append(s.substring(0, i1 + 2));
    small_buffer.append(host_port);
    small_buffer.append(s.substring(i2));
    result = small_buffer.toString();
    return result;
  }

  protected String modifyHost(String s) {
    String result = null;
    small_buffer.delete(0, small_buffer.length());
    int index = s.indexOf(':');
    small_buffer.append(s.substring(0, index + 2));
    small_buffer.append(host_port);
    result = small_buffer.toString();
    return result;
  }

  protected String modifyCookie(String s) {
    if(!toParseCookie) {
      return s;
    }
    String result = null;
    small_buffer.delete(0, small_buffer.length());
    int index = s.indexOf(':') + 1;
    updateCookie(s.substring(index));
    small_buffer.append(s.substring(0, index));
    small_buffer.append(actual_cookie);
    result = small_buffer.toString();
    return result;
  }

  protected String modifyConnection(String s) {
    String result = null;
    small_buffer.delete(0, small_buffer.length());
    int index = s.indexOf(':');
    small_buffer.append(s.substring(0, index + 2));
    small_buffer.append("close");
    result = small_buffer.toString();
    return result;
  }

  protected void initSocket() throws IOException {
    if(connection) {
      socket = new Socket(host, port);
      socket.setSoTimeout(socketTimeout);
      is = socket.getInputStream();
      os = socket.getOutputStream();
    }
  }

  protected void closeSocket() throws IOException {
    is.close();
    os.close();
    socket.close();
  }

  protected String readLine(InputStream is) throws IOException {
    String result = null;
    small_buffer.delete(0, small_buffer.length());
    int b = -1;
    do {
      b = is.read();
      small_buffer.append((char) b);
      if(b == -1) throw new IOException("Stream end reached before reading line!");
    } while(b != (int) '\n');
    result = small_buffer.toString().trim();
    return result;
  }

  protected void makeDirs(File file) {
    File parent = file.getParentFile();
    if(parent != null && !parent.exists()) {
      parent.mkdirs();
    }
  }

  protected String parseCookie(String line) {
    String result = null;
    int index1 = line.indexOf(':') + 1;
    int index2 = line.indexOf(';');
    result = line.substring(index1, index2);
    //result == cookie
    index1 = result.indexOf("=");
    String key = result.substring(0 , index1 ).trim();
    cookies.put(key , result.substring(index1 + 1 , result.length()));
    Enumeration e = cookies.keys();
    result = "";
    String jsid = "";
    String sapj2ee = "";
    while(e.hasMoreElements()) {
      String k = (String)e.nextElement();
      String v = (String)cookies.get(k);

      if(k.equalsIgnoreCase("jsessionid")) {
        jsid = k + "=" + v;
      } else if(k.startsWith("saplb_")) {
        sapj2ee += k + "=" + v + ";";
      } else {
        result += k + "=" + v + ";";
      }
    }
    if(result.equals("")) {
      String temp = "";
      if(!jsid.equals("")) {
        //no sapj2ee
        temp = jsid + (sapj2ee.equals("") ? "" : ";");
      }
      if(!sapj2ee.equals("")) {
        //no jsessionid
        temp += sapj2ee.substring(0 , sapj2ee.length() -1);
      }
      result = temp;
    } else {
      String temp = "";
      if(!jsid.equals("")) {
        temp = jsid + ";";
        //no sapj2ee
      }
      if(!sapj2ee.equals("")) {
        //no jsessionid
        temp += sapj2ee;
      }
      result = temp + result.substring(0 , result.length() -1);
    }
    return result;
  }

  protected int parseContentLength(String line) {
    int result = -1;
    int index = line.indexOf(':') + 1;
    String len = line.substring(index).trim();
    result = Integer.parseInt(len);
    return result;
  }

  protected boolean parseConnection(String line) {
    boolean result = false;
    int index = line.indexOf(':') + 1;
    result = line.substring(index).trim().equals("close");
    return result;
  }
  protected String parseContentEncoding(String line) {
    String res = null;
    int index = line.indexOf(':');
    res = line.substring(index + 1).trim();
    return res;
  }

  protected boolean parseTransferEncoding(String line) {
    boolean result = false;
    int index = line.indexOf(':') + 2;
    result = line.substring(index).equals("chunked");
    return result;
  }

  private boolean isHTTP10Client(String request) {
    BufferedReader reader = new BufferedReader(new StringReader(request));
    try {
      String line = reader.readLine();

      if(line.endsWith("HTTP/1.0")) {
        reader.close();
        return true;
      }
      reader.close();
      return false;
    } catch(Exception  exc) {
      exc.printStackTrace();
      return false;
    }
  }
  /**
   * Makes single request , parse response and observes fro http errors.
   * If http errors occurs then error is logged and http error flag is raised.
   * if i/o error occurs then it is directly thrown for handeling from upper level.
   *
   * @param request request headers String presentation
   * @param mode flag fro connection status (close or keep-alive)
   * @throws IOException thrown if i/o error occurs
   */

  protected void getResult(String request, boolean mode) throws IOException {
    request = requestModifier(request, mode);//modifies request
    headersResp.clear();//clears Vector which is used in singleRequest method.
    bodyResp = null;
    log.log("------------------------request begining------------------------");
    log.log(request);//logs modified request
    log.log("------------------------ request ending ------------------------");
    byte[] byteToSend = request.getBytes();
    try {
      if(delay > 0) {
        Thread.sleep(delay);
      } else if (delay == -1) {
        Thread.sleep(time);
      }
    } catch(InterruptedException e) {
    }
    initSocket();
    try {
      os.write(byteToSend);
      os.flush();
    } catch(Exception e) {
      connection = true;
      initSocket();
      os.write(byteToSend);
      os.flush();
    }
    //if request starts with HEAD then no response body will be get!
    boolean body = !request.startsWith("HEAD");
    String header_source = "";
    String status = readLine(is);//first line of http response header
    header_source += status + "\r\n";
    headersResp.add(status);
    log.log("------------------------response header begin------------------------");
    log.log(status);
    int sp1 = status.indexOf(' ');
    int sp2 = status.indexOf(' ', sp1 + 1);
    status = status.substring(sp1 + 1, sp2);
    //check if there will be response body or not
    body &= !(status.startsWith("1") || status.startsWith("204") || status.startsWith("304"));
    String header = null;

    boolean n_con = false;//type of connection (close or keep-alive ) that is described in response header
    //n_con == true -> connection status is close
    //n_con == false -> connection status is keep-alive
    boolean is_there_connection_header = false;//flag for connection header line existing in reponse header
    boolean chunked = false;//chunk response
    boolean isArchived = false;//if true then response body is archived
    int c_length = -1;//content length

    //reponse header reading begin

    while(true) {
      header = readLine(is);
      if(header.equals("")) break;
      header_source += header + "\r\n";
      String headerToLowerCase = header.toLowerCase();
      if(headerToLowerCase.startsWith("set-cookie")) {
        if (headerToLowerCase.indexOf("jsessionid") > -1 || headerToLowerCase.indexOf("saplb_") > -1) {
          actual_cookie = parseCookie(header);
        }
      } else if(headerToLowerCase.startsWith("connection")) {
        is_there_connection_header = true;
        //if there is no connection header line then connection is considered for keep-alive
        n_con = parseConnection(header);
      } else if(headerToLowerCase.startsWith("transfer-encoding")) {
        chunked = parseTransferEncoding(header);
      } else if(headerToLowerCase.startsWith("content-length")) {
        c_length = parseContentLength(header);
      } else if(headerToLowerCase.startsWith("content-encoding")) {
        String encoding = parseContentEncoding(header);
        if(encoding.toLowerCase().indexOf("gzip") != -1) {
          isArchived = true;
        }
      } else if(headerToLowerCase.startsWith("www-authenticate: basic")) {
        authenticate = true;
      }
      log.log(header);//write to log file current header line.
      headersResp.add(header);
    }
    //makes verification check of response header
    if(chunked) {
      if(!n_con && is_there_connection_header) {
        logHttp("Response header verification error!\r\n"+
                "Header contains chunked status but connection is not described as keep-alive!\r\n", ERROR);
      }
      if(c_length != -1) {
        logHttp("Response header verification error!\r\n"+
                "Header contains chunked status but content length is described in response it's value is : " + c_length +
                "\r\n", ERROR);
      }
    } else {
      if(!n_con && is_there_connection_header) {
        if(c_length == -1 && !status.startsWith("304")) {
          logHttp("Response header verification error!\r\n"+
                  "Response header returns keep-alive connection but do not describe any content_length!\r\n", ERROR);
        }
      }
    }
    //response header read end
    //flag for type of connection(close or keep-alive)
    if(!is_there_connection_header && isHTTP10Client(request)) {
      //setconnection to close
      connection = true;
    } else {
      connection = n_con || mode || chunked;
    }
    log.log("------------------------response header end------------------------");
    if(body) {
    log.log("------------------------response body begin------------------------");
      int check = -1;
      int count = 0;
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      byte[] buffer = new byte[8096];
      //In this case response
      if(c_length == -1 && connection) {
        if (chunked) {
          readChunked(baos);
        } else {
          //reades to the end of stream.
          //in this case keep-alive connection is returned  but no content_length is described!!!
          //http error is fixed !!!!!!
          while((check = is.read(buffer)) != -1) {
             if(!isArchived) {
               log.log(buffer, 0, check);
             }
             baos.write(buffer, 0, check);
          }
        }
        closeSocket();
      } else if(c_length > 0) {//content_length exists in response header!
				int size = ((c_length - count) > buffer.length) ? buffer.length: (c_length - count) ;
				while ((size > 0) && (check = is.read(buffer,0,size)) != -1) {
					count += check;
          if(!isArchived) {
            log.log(buffer, 0, check);
          }
          baos.write(buffer, 0, check);
					size = ((c_length - count) > buffer.length) ? buffer.length: (c_length - count) ;
				}
        closeSocket();
				if (c_length != count)	{
          logHttp("Response body is not fully readed.Stream is closed before reach content_length value!\r\n" +
                  "content_length : " + c_length + "\r\nreaded bytes count : " + count + "\r\n", ERROR);
				}
      }
      bodyResp = baos.toByteArray();
      byte[] temporary = null;
      //if response is archived then it is unziped and wrote in log file.
      if (isArchived) {
        try {
          temporary = unzipAndWriteToLog(bodyResp);
        } catch(Exception e) {
          //http error ... responce data do not represents real archive
          logHttp("Response is fixed as gzip , but response body do not contains regular archive data. Problem is : " , e , ERROR);
e.printStackTrace();
        }
      } else if(chunked) {
        //in this case readChunked() method was called and response body have to be logged.
        log.log(bodyResp , 0 , bodyResp.length);
      }
      //used to store every response in specefied file
      if(dirForResponse != null) {
        String sss = null;
        try {
          String responseFilePath = getResponseFileName(request).replace('/'  ,File.separatorChar);
          sss = dirForResponse + responseFilePath;
          relativePathForResponse = dirForResponseName + responseFilePath;
          new File(sss.substring(0 , sss.lastIndexOf(File.separatorChar))).mkdirs();
          FileOutputStream outTo = new FileOutputStream(sss);
          if(temporary != null) {
            outTo.write(temporary);
          } else {
            outTo.write(bodyResp);
          }
          outTo.flush();
          outTo.close();
        } catch(Exception ee) {
          System.out.println("Error creating response file : " + sss + ".Error is : " + ee.getMessage());
        }
      }
      log.log("------------------------response body end------------------------");
    }
  }

    protected String readFullLine(String str , int start) {
    String result = null;
    int current = start;
    if (current == str.length() - 1)  {
      return null;
    }
    do {
      current++;
    } while((current < str.length() - 1) && (str.charAt(current) != '\n'));
    if (current > str.length() ) {
      return null;
    }
    result = str.substring(start, current + 1);
    return result;
  }

  public Hashtable singleRequest(String request) throws IOException , HttpException {
    authenticate = false;
    if (!isInit) {
      initialize();
    }
    errorInHttp = false;
    String[] heads = null;
    boolean close = false;
    int index = 0;
    String line = null;
    //parse request and gets connection type
    while ((line = readFullLine(request , index)) != null) {
      index += line.length();
      if (line.startsWith("Connection")) {
        close = parseConnection(line);
      }
    }
    //makes request and gets response result
    getResult(request,close);

    heads = new String[headersResp.size()];//headers
    headersResp.copyInto(heads);
    responseHash.clear();//clears Hashtable with reponse resources
    //cookies.clear();
    if (bodyResp != null) {
      responseHash.put("body" , bodyResp);
    }
    responseHash.put("headers" , heads);
    if(errorInHttp) {
      throw new HttpException("Error in http response headers" , responseHash);
    }
    return responseHash;
  }

  public String getHttpResponseLogRelativePath() {
    return relativePathForResponse;
  }

  private void logHttp(String message , byte type) {
    try {
      if(type == ERROR) {
        errorInHttp = true;
      }
//      if(internalLog != null) {
//        internalLog.write((HEADERS_ARRAY[type] + " : | " + message + " |\r\n"+ linelogSeparator +"\r\n").getBytes());
//      }
      if(log != null) {
        log.log(HEADERS_ARRAY[type] + " : | " + message + " |\r\n"+ linelogSeparator +"\r\n");
      }

    } catch(Exception ee) {
      ee.printStackTrace();
    }
  }

  private void logHttp(String message , Exception e , byte type) {
    logHttp(message + "\r\n" + Utilities.exceptionToString(e) + "\r\n" , type);
  }

  private void readChunked(ByteArrayOutputStream bo) throws IOException {
    int c;
    ByteArrayOutputStream chunSize = new ByteArrayOutputStream();
   // ByteArrayOutputStream bo = new ByteArrayOutputStream();
    while(true) {
      c = is.read();
      if (c == -1) {
        break;
      }
      if (c == 13 && is.read() == 10) {
        if (chunSize.size() == 0) {
          continue;
        }
        int bytesToRead = Integer.parseInt(chunSize.toString(), 16);
        chunSize.reset();
        if(bytesToRead == 0) {
          break;
        }
        for(int r =0; r < bytesToRead;r++) {
          bo.write(is.read());
        }
      } else {
        chunSize.write(c);
      }
    }
    //return bo.toString();
  }

  private byte[] unzipAndWriteToLog(byte[] source) throws IOException {
    ByteArrayInputStream bais = new ByteArrayInputStream(source);
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    GZIPInputStream zip = new GZIPInputStream(bais);
    byte[] b = new byte[2048];
    int readed = 0;
    while (true) {
      readed = zip.read(b , 0 , b.length);
      if(readed == -1) break;
      try {
        baos.write(b , 0 , readed);
        log.log(b , 0 , readed);

      } catch (Exception exc) {
        //log to file exception
        System.out.println("External system log error!");
        exc.printStackTrace();
      }
    }
    zip.close();
    baos.flush();
    byte[] res = baos.toByteArray();
    baos.close();
    return res;
  }
}
