package com.inqmy.ats.system;

import java.util.*;
import com.inqmy.ats.*;
import com.inqmy.ats.provider.CoreContext;

/**
 * This class is the factory of environments that test which implements interface com.inqmy.ats.Test can use.
 * Every environment implementation have its own properties object generated from information in
 * "<ATS_HOME>/bin/default.properties" file these are deafult system properties.
 * When a test gets such environment it can pass properties object to it.
 * In that case the keys and values in test property object overrides
 * the keys and values in default system properties object(two propeties are merged).
 */
public final class EnvironmentFactory {
  /**
   * Id of DatabaseEnvironment.
   */
  public final static int DATABASE = 0;
  /**
   * Id of DeployEnvironment.
   */
  public final static int DEPLOY = 1;

  /**
   * Id of LogEnvironment.
   */
  public final static int LOG = 2;

  /**
   * Id of NamingEnvironment.
   */
  public final static int NAMING = 3;

  /**
   * Id of UserEnvironment.
   */
  public final static int USER = 4;

  /**
   * Id of ShellEnvironment.
   */
  public final static int SHELL = 5;
  
  /**
   * Id of TestEnvironment.
   */
  public final static int TEST = 6;
  
  /**
   * Id of HTTPEnvironment.
   */
  public final static int HTTP = 7;
  /**
   * Id of SDMEnvironment.
   */
  public final static int SDM = 8;
  /**
   * Id of ClusterEnvironment.
   */
  public final static int CLUSTER = 9;


  private static EnvironmentFactory env = null;
  
  public static Properties envs = CoreContext.getTestContext().getDefaultProperties();


  private Vector environments = new Vector();


  private EnvironmentFactory() {
  }
  /**
   * Returns EnvironmentFactory instance.
   *
   * @return EnvironmentFactory instance.
   */
  public static synchronized EnvironmentFactory getEnvironmentFactory() {
    if(env == null) {
      env = new EnvironmentFactory();
    }
    return env;
  }
  /**
   * Returns Environment implementation object with spedefied id,
   * using passed properties.
   *
   * @param p          properties that test passed to environment.
   * @param env        environment id.
   * @return           Environment implementation object.
   * @throws Exception if error occurs.
   */
  public static Environment getEnvironment(Properties p, int env) throws Exception {
    if (!p.equals(envs)) {
      p = mergeWithDefaultProps(p);
    }
    String rootdir = CoreContext.getTestContext().getTestDir();
    Environment result = null;
    String[] names = CoreContext.getTestContext().getTestEnvironment().getEnvironmentNames();
    if ((names.length <= env) || (env < 0) || (names[env] == null)) {

      return null;
    }

    result = (Environment)Class.forName(names[env]).newInstance();
    result.init(p);
    getEnvironmentFactory().environments.add(result);
    return result;
  }
  /**
   * Returns Environment implementation with given id and passes to it default system properties.
   *
   * @param env        id of environment.
   * @return           Environment implementation.
   * @throws Exception if error occurs.
   */
  public static Environment getEnvironment(int env) throws Exception {
    return getEnvironment(envs , env);
  }
  
  private static Properties mergeWithDefaultProps(Properties p) {
    Enumeration keys = p.keys();
    Properties defClone = (Properties)envs.clone();
    String key = null;
    while (keys.hasMoreElements()) {
      key = (String) keys.nextElement();
      defClone.setProperty(key , p.getProperty(key));
    }
    return defClone;
  }

 /**
  * Closes all environments instances which are took from factory.
  * This method is called automatically after execution of all methods of a given test class.
  */
 public static synchronized void close() {
   Vector environments = getEnvironmentFactory().environments;
   int size = environments.size();
   if (size == 0) return;
   for (int i=0;i<size;i++) {
     try {
       ((Environment)environments.elementAt(i)).close();
     } catch(Exception ex) {}
   }
   environments.clear();
  }
}