package com.inqmy.ats.system;

import java.io.*;
import java.util.*;
import java.rmi.RemoteException;
import java.util.zip.*;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.file.RemoteFile;
import com.sap.engine.services.file.FileTransfer;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.DeployCallbackImpl;
import com.sap.engine.services.deploy.DeployListener;
import com.sap.engine.services.deploy.DeployEvent;
import com.sap.engine.services.deploy.exceptions.EarWontBeConvertedException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.container.ProgressEvent;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.converter.EARConverter;
import javax.naming.Context;

import com.inqmy.ats.provider.CoreContext;
import com.inqmy.ats.provider.tools.ATSClassLoader;
import com.inqmy.ats.DeployEnvironment;
import com.inqmy.ats.system.tools.TimeoutAction;
import com.inqmy.ats.system.tools.Utilities;

public final class DeployEnvironmentImpl implements DeployEnvironment, TimeoutAction {

  private String[] defaultSupports = null;

  private Properties defaultProperties = null;

  private DeployService deploy = null;

  private  DeployService dsForClose = null;

  private FileTransfer transferer = null;

  private NamingEnvironmentImpl naming = null;

  private Vector dApp = null;

  private Vector dLibs = null;

  private Vector client_jars = null;

  private String root = null;

  private boolean toClose = false;

  private Properties p;

  private Context ctx = null;

  private boolean appRemove = true;



  public void init(Properties p) throws Exception {
    String root = CoreContext.getTestContext().getTestDir();
    this.root = root;
    this.p = p;

    if(p.getProperty("application_remove", "true").trim().equals("false")) {
      appRemove = false;
    } else {
      appRemove = true;
    }
    naming = new NamingEnvironmentImpl();
    naming.init(p);
    ctx = naming.getContext();
    client_jars = new Vector();
    String supports = p.getProperty("remote_supports", "p4").trim();
    Exception res = (Exception)Utilities.runAction(5*60*1000 , this);
    if(res != null) {
      throw res;
    }
    this.defaultSupports = getSupports(supports);
    this.defaultProperties = getProperties(p);
    this.dApp = new Vector();
    this.dLibs = new Vector();
  }

  public Object run() {
    try {
      this.deploy = (DeployService) ctx.lookup("deploy");
      transferer = (FileTransfer) ctx.lookup("file");
    } catch(Exception exc) {
      return exc;
    }
    return null;
  }


  public DeployEnvironmentImpl() throws Exception {
  }

  private Properties getProperties(Properties p) {
    Properties result = new Properties();
    String value = null;
    value = p.getProperty("specification", "J2EE_1_2").trim();
    result.put("specification", value);
    value = p.getProperty("root_lookup", "false").trim();
    result.put("root_lookup", value);
    value = p.getProperty("container_type", "B").trim();
    result.put("container_type", value);
    return result;
  }

  private String[] getSupports(String sup) {
    String[] result = null;
    StringTokenizer token = new StringTokenizer(sup, "; ");
    int count = token.countTokens();
    result = new String[count];
    for(int i = 0; i < count; i++) {
      result[i] = token.nextToken();
    }
    return result;
  }


  public String[] deploy(String archiveFile, String containerName, String[] remoteSupport, Properties props) throws Exception {
    String[] deployResults = null;
    try  {
      File ear_file = new File(archiveFile);
      if(!ear_file.exists() || !ear_file.isAbsolute()) {
        archiveFile = archiveFile.replace('/', File.separatorChar);
        archiveFile = archiveFile.startsWith(".") ? archiveFile.substring(1) : File.separator + archiveFile;
        archiveFile = root + archiveFile;
      } else {
        archiveFile = ear_file.getCanonicalPath();
      }
      RemoteFile remoteF = null;
      String serverEarName = "./services/deploy/work/deploying/" + new File(archiveFile).getName();
      remoteF = transferer.createRemoteFile(archiveFile, serverEarName);
      remoteF.upload();

      synchronized(deploy) {
        deployResults = deploy.deploy(serverEarName, containerName, remoteSupport, props);
      }
    } catch (RemoteException re) {
      if (re instanceof WarningException) {
        WarningException we = (WarningException)re;
        deployResults = we.getResult();
      } else {
        throw re;
      }
    }
    if(deployResults != null) {
      for(int i= 0 ; i < deployResults.length ; i ++) {
        if (deployResults[i] != null && deployResults[i].length() > 0 && deployResults[i].indexOf("Application : ") > -1) {
          String result = deployResults[i].substring("Application : ".length());
          this.startApplication(result);
          if (!dApp.contains(result)) {
            dApp.add(result);
          }
        }
      }
    }
    return deployResults;
  }

  public String deployEar(String earFile, boolean getRemoteSupports) throws Exception {
    return deployEar(earFile, getRemoteSupports, defaultProperties);
  }

  public String[] deployComponentsInEar(String earFile, boolean getRemoteSupports, Properties props) throws Exception {
    String result = null;
    String[] deployResults = null;
    File ear_file = new File(earFile);
    if(!ear_file.exists() || !ear_file.isAbsolute()) {
      earFile = earFile.replace('/', File.separatorChar);
      earFile = earFile.startsWith(".") ? earFile.substring(1) : File.separator + earFile;
      earFile = root + earFile;
    } else {
      earFile = ear_file.getCanonicalPath();
    }
    try  {
      RemoteFile remoteF = null;
      File earFile1 = new File(root, "newtemp.ear");
      String newEar = earFile1.getAbsolutePath();
      try {
        EARConverter conv = new EARConverter();
        System.out.println("CONVERTING " + newEar);
        conv.convert(earFile, newEar);
        if (earFile1.exists()) {
          earFile = newEar;
        }
      } catch (EarWontBeConvertedException earExc) {
        //do nothing!!!
      } catch (Exception e) {
        e.printStackTrace();
      }

      String serverEarName = "./services/deploy/work/deploying/" + new File(earFile).getName();
      remoteF = transferer.createRemoteFile(earFile, serverEarName);
      remoteF.upload();

      synchronized(deploy) {
        deployResults = deploy.deploy(serverEarName, defaultSupports, p);
      }
    } catch (RemoteException re) {
      if (re instanceof WarningException) {
        WarningException we = (WarningException)re;
        deployResults = we.getResult();
      } else {
        throw re;
      }
    }
    if(deployResults != null) {
      for(int i= 0 ; i < deployResults.length ; i ++) {
        result = deployResults[i].substring("Application : ".length());
        if (!dApp.contains(result)) {
          dApp.add(result);
        }
        if(getRemoteSupports) {
          SerializableFile serFile = null;
          synchronized(deploy) {
            serFile = deploy.getClientJar(result);
          }
          if (serFile != null) {
            saveJar(root , serFile);
          }
        }
      }
    }

    // Start the applications :
    if(deployResults != null) {
      for(int i= 0 ; i < deployResults.length ; i ++) {
        result = deployResults[i].substring("Application : ".length());
        this.startApplication(result);
      }
    }
    return deployResults;
  }

  public String deployEar(String earFile, boolean getRemoteSupports, Properties p) throws Exception {
    String result = null;
    String[] deployResults = null;
    File ear_file = new File(earFile);
    if(!ear_file.exists() || !ear_file.isAbsolute()) {
      earFile = earFile.replace('/', File.separatorChar);
      earFile = earFile.startsWith(".") ? earFile.substring(1) : File.separator + earFile;
      earFile = root + earFile;
    } else {
      earFile = ear_file.getCanonicalPath();
    }
    try  {
      RemoteFile remoteF = null;
      File earFile1 = new File(root, "newtemp.ear");
      String newEar = earFile1.getAbsolutePath();
      try {
        EARConverter conv = new EARConverter();
        System.out.println("CONVERTING " + newEar);
        conv.convert(earFile, newEar);
        if (earFile1.exists()) {
          earFile = newEar;
        }
      } catch(EarWontBeConvertedException ewbc) {

      } catch (Exception e) {
        e.printStackTrace();
      }

      String serverEarName = "./services/deploy/work/deploying/" + new File(earFile).getName();
      remoteF = transferer.createRemoteFile(earFile, serverEarName);
      remoteF.upload();

      synchronized(deploy) {
        deployResults = deploy.deploy(serverEarName, defaultSupports, p);
      }
    } catch (RemoteException re) {
      if (re instanceof WarningException) {
        WarningException we = (WarningException)re;
        deployResults = we.getResult();
      } else {
        throw re;
      }
    }
    if(deployResults != null) {
      result = deployResults[0].substring("Application : ".length());
      if (!dApp.contains(result)) {
        dApp.add(result);
      }
      if(getRemoteSupports) {
        SerializableFile serFile = null;
        synchronized(deploy) {
          serFile = deploy.getClientJar(result);
        }
        if (serFile != null) {
          saveJar(root , serFile);
        }
      }
    }
    // Start the application :
    this.startApplication(result);
    return result;
  }

  public String update(String earFile, boolean getRemoteSupports) throws Exception {
    return update(earFile, getRemoteSupports, defaultProperties);
  }

  public String update(String earFile, boolean getRemoteSupports, Properties p) throws Exception {
    String result = null;
    String[] updateResults = null;
    earFile = fixPath(earFile);
    try  {
      RemoteFile remoteF = null;
      String serverEarName = "./services/deploy/work/deploying/" + new File(earFile).getName();
      try {
        File earFile1 = new File(root, "newtemp.ear");
        String newEar = earFile1.getAbsolutePath();
        EARConverter conv = new EARConverter();
       // System.out.println("CONVERTING " + newEar);
        conv.convert(earFile, newEar);
        if (earFile1.exists()) {
          earFile = newEar;
        }
      } catch(EarWontBeConvertedException ewc) {
        //do nothing
      } catch (Exception e) {
        e.printStackTrace();
      }

      remoteF = transferer.createRemoteFile(earFile, serverEarName);
      remoteF.upload();
      synchronized(deploy) {
        updateResults = deploy.update(serverEarName, p);
      }
    } catch (WarningException we) {
      updateResults = we.getResult();
    }
    if(updateResults != null) {
      result = updateResults[0].substring("Application : ".length());
      if(getRemoteSupports) {
        SerializableFile serFile = null;
        synchronized(deploy) {
          serFile = deploy.getClientJar(result);
        }
        saveJar(root , serFile);
      }
    }
    // Start the application :
    this.startApplication(result);
    return result;
  }

  public void remove(String application) throws Exception {
//System.out.println("removing : " + application );
    synchronized(deploy) {
      if (!toClose) {
        dApp.remove(application);
      }
      if(toClose){
        if(dsForClose == null) {
          dsForClose = ((DeployService) naming.getContext().lookup("deploy"));
          dsForClose.remove(application);
        } else {
          dsForClose.remove(application);
        }
      } else {
        deploy.remove(application);
      }
    }
  }

  private String[] fixPath(String[] jars) {
    String[] result = new String[jars.length];
    for(int i = 0; i < jars.length; i++) {
      result[i] = jars[i].replace('/', File.separatorChar);
      result[i] = result[i].startsWith(".") ? result[i].substring(1) : File.separator + result[i];
      result[i] = root + result[i];
    }
    return result;
  }

  private String fixPath(String path) {
    String s = path.replace('/' , File.separatorChar);
    File f = new File(s);
    if(f.exists()) {
      return path;
    } else {
      s = s.startsWith(".") ? s.substring(1) : File.separator + s;
      return root + s;
    }

  }
  public void deployLibrary(String libName , String jar) throws Exception {
    jar = fixPath(jar);

    RemoteFile remoteF = null;
    String serverLibName = "./services/deploy/work/deploying/" + new File(jar).getName();
    remoteF = transferer.createRemoteFile(jar, serverLibName);
    remoteF.upload();

    synchronized(deploy) {

      deploy.deployLibrary(serverLibName);
      if(!dLibs.contains(libName)){
        dLibs.add(libName);
      }
    }

  }

  public String[] updateComponents(String earFile, Properties props, boolean getRemoteSupports) throws Exception {
    String result = null;
    String[] updateResults = null;
    earFile = fixPath(earFile);
    try  {
      RemoteFile remoteF = null;
      String serverEarName = "./services/deploy/work/deploying/" + new File(earFile).getName();
      try {
        File earFile1 = new File(root, "newtemp.ear");
        String newEar = earFile1.getAbsolutePath();
        EARConverter conv = new EARConverter();
        //System.out.println("CONVERTING " + newEar);
        conv.convert(earFile, newEar);
        if (earFile1.exists()) {
          earFile = newEar;
        }
      } catch(EarWontBeConvertedException ewc) {
        //do nothing) {
      } catch (Exception e) {
        e.printStackTrace();
      }

      remoteF = transferer.createRemoteFile(earFile, serverEarName);
      remoteF.upload();
      synchronized(deploy) {
        updateResults = deploy.update(serverEarName, p);
      }
    } catch (WarningException we) {
      updateResults = we.getResult();
    }
    if(updateResults != null) {
      result = updateResults[0].substring("Application : ".length());
      if(getRemoteSupports) {
        SerializableFile serFile = null;
        synchronized(deploy) {
          serFile = deploy.getClientJar(result);
        }
        saveJar(root , serFile);
      }
    }
    // Start the application :
    this.startApplication(result);
    return updateResults;
  }

  public String[] update(String archiveFile, String containerName, String[] remoteSupport, Properties props) throws Exception {
    String[] deployResults = null;
    try  {
      archiveFile = fixPath(archiveFile);
      RemoteFile remoteF = null;
      String serverEarName = "./services/deploy/work/deploying/" + new File(archiveFile).getName();
      remoteF = transferer.createRemoteFile(archiveFile, serverEarName);
      remoteF.upload();

      synchronized(deploy) {
        deployResults = deploy.update(serverEarName, containerName, remoteSupport, props);
      }
    } catch (WarningException re) {
      deployResults = re.getResult();
    }
    if(deployResults != null) {
      for(int i= 0 ; i < deployResults.length ; i ++) {
        if (deployResults[i] != null && deployResults[i].length() > 0 && deployResults[i].indexOf("Application : ") > -1) {
          String result = deployResults[i].substring("Application : ".length());
          this.startApplication(result);
        }
      }
    }
    return deployResults;
  }

  public void deployLibrary(String libName, String[] jars) throws Exception {
    synchronized(deploy) {
      String[] jars1 = fixPath(jars);
      this.deployLibrary(libName , jars1[0]);
    }
  }

  public void updateLibrary(String libName, String[] jars) throws Exception {
    throw new Exception("Not supported operation");
  }

  public void removeLibrary(String libName) throws Exception {
    synchronized(deploy) {
      if (!toClose) {
        dLibs.remove(libName);
      }
      deploy.removeLibrary(libName);
    }
  }

  public void makeReferences(String fromApplication, String[] toLibraries) throws Exception {
    synchronized(deploy) {
      deploy.makeReferences(fromApplication, toLibraries);
    }
  }

  public void removeReferences(String fromApplication, String[] toLibraries) throws Exception {
    synchronized(deploy) {
      deploy.removeReferences(fromApplication , toLibraries);
    }
  }

  public String getApplicationStatus(String applicationName) throws Exception {
    String result = null;
    synchronized(deploy) {
      result = deploy.getApplicationStatus(applicationName);
    }
    return result;
  }

  public void stopApplication(String applicationName) throws Exception {
    String appStatus = this.getApplicationStatus(applicationName);
    if("STOPPED".equals(appStatus)) {
      return;
    }
    synchronized(deploy) {
      try {
        deploy.stopApplicationAndWait(applicationName);
      } catch (WarningException exc) {
        exc.printStackTrace();
      }
      //deploy.stopApplication(applicationName);
    }
  }
  /**
   * If two threads try to start the same application using this method
   * then one of them will be blocked.
   *
   * @param applicationName
   * @throws Exception
   */
  public void startApplication(String applicationName) throws Exception {
    String appStatus = this.getApplicationStatus(applicationName);
    if("STARTED".equals(appStatus)) {
      return;
    }
    synchronized(deploy) {
      try {
        deploy.startApplicationAndWait(applicationName);
      } catch (WarningException exc) {
        exc.printStackTrace();
      }
    }
  }

  public void stopApplication(String applicationName, String[] serverNames) throws Exception {
    String appStatus = this.getApplicationStatus(applicationName);
    if("STOPPED".equals(appStatus)) {
      return;
    }
    synchronized(deploy) {
      try {
        deploy.stopApplicationAndWait(applicationName , serverNames);
      } catch (WarningException exc) {
        exc.printStackTrace();
      }
    }
  }

  public void startApplication(String applicationName, String[] serverNames) throws Exception {
    String appStatus = this.getApplicationStatus(applicationName);
    if("STARTED".equals(appStatus)) {
      return;
    }
    synchronized(deploy) {
      try {
        deploy.startApplicationAndWait(applicationName , serverNames);
      } catch (WarningException exc) {
        exc.printStackTrace();
      }
    }
  }

  public void singleFileUpdate(FileUpdateInfo[] files, String appName, Properties props) throws Exception {
    /*
    RemoteFile remoteF = null;
    for(int i = 0 ; i < files.length ; i++) {
      File localFile = new File(fixPath(files[i].getFileName()));
      String serverEarName = "./temp/deploy/work/singleUpdate/" + localFile.getName();
      remoteF = transferer.createRemoteFile(localFile.getPath(), serverEarName);
      remoteF.upload();

      serverEarName = serverEarName.replace('/' , File.separatorChar);

      File tempFile = new File(serverEarName);
      tempFile.getParentFile().mkdirs();
      Utilities.copyFiles(localFile , tempFile);
      files[i].setFileName(serverEarName);
      Utilities.delTree(new File("." + File.separatorChar + "services") , true);
    }
    synchronized(deploy) {
      deploy.singleFileUpdate(files , appName , props);
    }
    */
    RemoteFile remoteF = null;
    String file = null;
    String destinationDir = "./temp/deploy/work/singleUpdate/" + appName + "/";
    for (int i = 0; i < files.length; i++) {
      file = destinationDir + new File(files[i].getFileName()).getName();
      remoteF = transferer.createRemoteFile(files[i].getFileName(), file);
      remoteF.upload();
      files[i].setRemoteFileName(file);
    }
    synchronized(deploy) {
      deploy.singleFileUpdate(files, appName, new Properties());
    }

  }

  public void close() throws Exception {
    if(!toClose) {
      try {
        ClassLoader loader = EnvironmentFactory.class.getClassLoader();
        ATSClassLoader ccc = (ATSClassLoader)loader;
        File clientFile = null;
        for (int i = 0 ; i < client_jars.size() ; i++) {
          clientFile = (File)client_jars.get(i);
          try {
            ccc.removeFromStore(clientFile.getCanonicalPath());
          } catch (Exception e) {
            System.out.println("Can not remove jar from class path!Error is : ");
            e.printStackTrace();
          }
        }
      } catch(Throwable thr) {
        thr.printStackTrace();
      }

      try {
        toClose = true;
        File clientFile = null;
        for (int i = 0 ; i < client_jars.size() ; i++) {
          clientFile = (File)client_jars.get(i);
          if(!clientFile.delete()){
            System.out.println("[DeployEnvironment ERROR] : can not delete client file : " + clientFile.getPath());
          }
        }
      } catch(Exception exc) {
        System.out.println("Can't delete : " );
      }
      if (appRemove) {
        String appName = null;
        for(int i = 0; i < dApp.size(); i++) {
          appName = (String) dApp.get(i);
          try {
            remove(appName);
          } catch(Exception e){
            System.out.println("[DeployEnvironment ERROR] : can not remove application : " +appName+ " : " + e);
          }
        }

        String libName = null;
        for(int i = 0; i < dLibs.size(); i++) {
          libName = (String) dLibs.get(i);
          try {
            removeLibrary(libName);
          } catch(Exception e){
            System.out.println("[DeployEnvironment ERROR] : can not remove application : " +libName+ " : " + e);
          }
        }
      }
      dApp = null;
      dLibs = null;

      naming.close();
    }
  }


  private void saveJar(String path , SerializableFile f) {
    try {
      byte[] toWrite = f.getBytes();
      ByteArrayInputStream is = new ByteArrayInputStream(toWrite);
      int dot = f.getFileName().indexOf('.');
      if (dot == -1) {
        dot = f.getFileName().length();
      }
      File client_jar_file = File.createTempFile(f.getFileName().substring(0, dot) ,".jar" ,new File(path));
      client_jars.add(client_jar_file);
      FileOutputStream out = new FileOutputStream(client_jar_file);
      modifyJar(out, is);
      out.flush();
      is.close();
      out.close();
    } catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void modifyJar(OutputStream out, InputStream in) throws Exception {
    ZipInputStream zis = new ZipInputStream(in);
    ZipOutputStream zos = new ZipOutputStream(out);
    zos.setLevel(0);
    ZipEntry ze = null;
    String zeName = null;
    while((ze = zis.getNextEntry()) != null) {
      zeName = ze.getName().replace('\\', '/');
      zos.putNextEntry(new ZipEntry(zeName));
      copyEntry(zos, zis);
    }
    zos.flush();
    zos.finish();
  }

  private void copyEntry(ZipOutputStream zos, ZipInputStream zin) throws IOException {
    byte[] buffer = new byte[1024];
    int check = -1;
    while((check = zin.read(buffer, 0, buffer.length)) > 0) {
      zos.write(buffer, 0, check);
    }
    zos.flush();
  }

}