package com.inqmy.ats.system;

import java.io.*;
import java.sql.*;
import java.util.*;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.engine.services.adminadapter.impl.ManagementInterfaceProxyFactoryImpl;
import com.inqmy.ats.provider.CoreContext;
import com.inqmy.ats.DatabaseEnvironment;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;

final class DatabaseEnvironmentImpl implements DatabaseEnvironment {

  private Vector pools = new Vector();

  private DataSourceManager poolManager = null;

  private String DBDriver = null;

  private String DBDriverFile = null;

  private String DBURL = null;

  private String DBUser = null;

  private String DBPassword = null;

  private Connection qcon = null;

  private Statement qstate = null;

  private String root = null;

  private boolean toClose = false;

  private static final String DBPOOL = "dbpool";

  private Properties p;

  private boolean isServerDriverUsed = false;
  /**
   * Admin lookup constant
   */
  private static final String ADMIN = "adminadapter";

  private static String dtd = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n"+
          "<!DOCTYPE data-sources SYSTEM 'data-sources.dtd'>";

  private static String dtd_alias = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n"+
          "<!DOCTYPE data-source-aliases SYSTEM 'data-source-aliases.dtd'>";

  public void init(Properties p) throws Exception {
    String root = CoreContext.getTestContext().getTestDir();
    this.p = p;
    this.root = root;
    DBDriver = p.getProperty("db_driver", "solid.jdbc.SolidDriver").trim();
    DBDriverFile = p.getProperty("db_driver_file", "../lib/SolidDriver.zip").trim();
    DBURL = p.getProperty("db_url", "jdbc:solid://localhost:1313").trim();

    int ind = DBURL.indexOf("&");
    if (ind != -1) {
      String temp = DBURL.substring(0 , ind) + "&amp;";
      int ind1 = ind + 1;
      while (true) {
        ind = DBURL.indexOf("&" , ind1);
        if(ind == -1) {
          temp += DBURL.substring(ind1);
          break;
        }
        temp += DBURL.substring(ind1 , ind) + "&amp;";
        ind1 = ind + 1;
      }
      DBURL = temp;
    }

    DBUser = p.getProperty("db_user", "Administrator").trim();
    DBPassword = p.getProperty("db_password", "").trim();
    isServerDriverUsed =  (p.getProperty("secure_store_used_for_db") != null);

    Class.forName(DBDriver);
    NamingEnvironmentImpl naming = new NamingEnvironmentImpl();
    naming.init(p);
//RK    ServiceAdministrator sa = ((RemoteAdminInterface)naming.lookup(ADMIN)).getServiceAdministrator();
//RK    poolManager = (DataSourceManager)sa.generateCurrentManagementInterfaceProxy(DBPOOL);
    poolManager = (DataSourceManager) new ManagementInterfaceProxyFactoryImpl(naming.getContext().getEnvironment()).generateCurrentManagementInterfaceProxy(DBPOOL, DataSourceManager.class);
//KR
    SerializableFile[] sf = null;
    if(DBDriverFile.indexOf(";") != -1) {
      StringTokenizer tokenizer = new StringTokenizer(DBDriverFile , ";");
      int tokensCount = tokenizer.countTokens();
      sf = new SerializableFile[tokensCount];
      for (int i = 0 ; i < tokensCount ; i++) {
        sf[i] = new SerializableFile(tokenizer.nextToken());
      }
    } else {
      sf = new SerializableFile[]{new SerializableFile(DBDriverFile)};
    }
    if(!isServerDriverUsed) {
      poolManager.deployJdbcDriver(DBDriver, sf);
    }
  }

  public DataSourceManager getDataSourceManager() {
    return poolManager;
  }

  public DatabaseEnvironmentImpl() throws Exception {
  }

  public void undeployJdbcDriver(String driverName) throws Exception {
    poolManager.undeployJdbcDriver(driverName);
  }
  public String getDefaultDSName() throws Exception {
    JDBCDescriptor defDS = poolManager.getSystemDataSourceDescriptor();

    if (defDS == null) {
      return null;
    } else {
      return defDS.getDataSourceName();
    }
  }
  public String createDataSource(String name, int maxConection, int defConection) throws Exception {
    String fileString = dtd;
    File file = File.createTempFile("dbpool","tmp",new File(root));
    String appName = name +"_application";
    fileString +="<data-sources>\r\n";
    fileString +="<application-name>" + appName + "</application-name>\r\n";
    fileString +="<data-source>\r\n";
    fileString +="\t<data-source-name>"+name+"</data-source-name>\r\n";
    if(!isServerDriverUsed) {
      fileString +="\t<driver-name>"+DBDriver+"</driver-name>\r\n";
    } else {
      fileString +="\t<driver-name>"+"SYSTEM_DRIVER"+"</driver-name>\r\n";
    }
    fileString +="\t<init-connections>"+defConection+"</init-connections>\r\n";
    fileString +="\t<max-connections>"+maxConection+"</max-connections>\r\n";
    fileString +="\t<sql-engine>"+"vendor_sql"+"</sql-engine>\r\n";
    fileString +="\t<jdbc-1.x>\r\n";
    fileString +="\t\t<driver-class-name>"+DBDriver+"</driver-class-name>\r\n";

    fileString +="\t\t<url>"+DBURL+"</url>\r\n";
    fileString +="\t\t<user-name>"+DBUser+"</user-name>\r\n";
    fileString +="\t\t<password>"+DBPassword+"</password>\r\n";
    fileString +="\t</jdbc-1.x>\r\n";
    fileString +="</data-source>\r\n";
    fileString +="</data-sources>\r\n";
    try	{
      FileOutputStream fos = new FileOutputStream(file);
      fos.write(fileString.getBytes());
      fos.flush();
      fos.close();
    } catch (Exception ex) {
      throw new RuntimeException("Cannot create data source because of "+ex.toString());
    }

    SerializableFile sf = new SerializableFile(file.getPath());
    if(!pools.contains(appName)) {
      pools.add(appName);
    }
    String res = poolManager.deploy(sf);


    return res;
  }

  public String createAliasForDataSource(String dataSourceName , String[] aliases) throws Exception {
    String fileString = dtd_alias;
    File file = File.createTempFile("ds_alias","tmp",new File(root));

    fileString +="<data-source-aliases>\r\n";
    fileString +="<aliases>\r\n";
    fileString +="<data-source-name>" + dataSourceName + "</data-source-name>\r\n";
    for (int i = 0 ; i < aliases.length ; i++ ) {
      fileString +="<alias>" + aliases[i] +"</alias>";
    }
    fileString +="</aliases>\r\n";
    fileString +="</data-source-aliases>\r\n";

    try	{
      FileOutputStream fos = new FileOutputStream(file);
      fos.write(fileString.getBytes());
      fos.flush();
      fos.close();
    } catch (Exception ex) {
      throw new RuntimeException("Cannot create data source because of "+ex.toString());
    }
    SerializableFile sf = new SerializableFile(file.getPath());
    String res = poolManager.deploy(sf);
    pools.add(res);
    return res;
  }

  public String createDataSource(String name) throws Exception {
    return this.createDataSource(name , 25, 1);
  }

  public void removeApplication(String appName) throws Exception {
    poolManager.removeApplication(appName);
  }

  public void deployJdbcDriver(String driverName, File[] driverFiles) throws Exception {
    SerializableFile[] drvs = new SerializableFile[driverFiles.length];
    for (int i=0;i< drvs.length;i++) {
      drvs[i] = new SerializableFile(driverFiles[i]);
    }
    poolManager.deployJdbcDriver(driverName , drvs);
  }
/*
public void createPool(String poolName) throws Exception {
createPool(poolName, 2, 1);
}

public void createPool(String poolName, int maxConection, int defConection) throws Exception {

String fileString = dtd;
File file = File.createTempFile("dbpool","tmp",new File(root));

fileString +="<app-data-source>\r\n";
fileString +="<data-source>\r\n";
fileString +="\t<driver-name>"+DBDriver+"</driver-name>\r\n";
fileString +="\t<data-source-name>"+poolName+"</data-source-name>\r\n";
//		fileString +="\t<alias>"+MyDataSourceAlias+"</alias>\r\n";
fileString +="\t<connections-number>"+maxConection+"</connections-number>\r\n";
fileString +="\t<init-connection-number>"+defConection+"</init-connection-number>\r\n";
fileString +="\t<jdbc-1.x>\r\n";
fileString +="\t\t<driver-class-name>"+DBDriver+"</driver-class-name>\r\n";
fileString +="\t\t<url>"+DBURL+"</url>\r\n";
fileString +="\t\t<user-name>"+DBUser+"</user-name>\r\n";
fileString +="\t\t<password>"+DBPassword+"</password>\r\n";
fileString +="\t</jdbc-1.x>\r\n";
fileString +="</data-source>\r\n";
fileString +="</app-data-source>\r\n";
try	{
FileOutputStream fos = new FileOutputStream(file);
fos.write(fileString.getBytes());
fos.flush();
fos.close();
} catch (Exception ex) {
throw new RuntimeException("Cannot create data source because of "+ex.toString());
}
SerializableFile sf = new SerializableFile(file.getPath());
poolManager.deploy(sf);

pools.add(poolName);

}

public void removePool(String poolName) throws Exception {
poolManager.removeApplication(poolName);
pools.remove(poolName);
}
/*
public String[] createPools(String xmlFile) throws Exception {

xmlFile = xmlFile.replace('/', File.separatorChar);
xmlFile = xmlFile.startsWith(".") ? xmlFile.substring(1) : File.separator + xmlFile;
xmlFile = root + xmlFile;
String[] result = null;
Vector v = new Vector();
StandardDOMParser parser = new StandardDOMParser();
parser.setValidation(true);
Document doc = parser.parse(xmlFile);
Element el = doc.getDocumentElement();
NodeList nodes = el.getChildNodes();
for (int index = 0; index < nodes.getLength(); index++) {
Node node = nodes.item(index);
if(node.getNodeName().equals("dbpool")) {
NodeList childNodes = node.getChildNodes();
String name = null;
int defc = 1;
int maxc = 1;
for (int i = 0; i < childNodes.getLength(); i++) {
Node child = childNodes.item(i);
short type = child.getNodeType();
if ((type == Node.ELEMENT_NODE) && (child.hasChildNodes())) {
if (child.getNodeName().equals("name")) {
name = child.getFirstChild().getNodeValue();
} else if (child.getNodeName().equals("defaultConns")) {
defc = Integer.parseInt(child.getFirstChild().getNodeValue());
} else if (child.getNodeName().equals("maxConns")) {
maxc = Integer.parseInt(child.getFirstChild().getNodeValue());
}
}
}
createPool(name, maxc, defc);
v.add(name);
}
}
result = new String[v.size()];
v.copyInto(result);
return result;
return null;
}

public void removePools(String[] poolNames) throws Exception {
for(int i = 0; i < poolNames.length; i++) {
removePool(poolNames[i]);
}
}
*/
  public void executeUpdate(String sql) throws Exception {
    StringTokenizer tokenizer = new StringTokenizer(sql, ";");
    Connection con = DriverManager.getConnection(DBURL, DBUser, DBPassword);
    Statement statement = con.createStatement();
    String sqlLine = null;
    while(tokenizer.hasMoreElements()) {
      sqlLine = tokenizer.nextToken().trim();
      if(sqlLine.equals("") || sqlLine.startsWith("#")) {
        continue;
      }
      if(sqlLine.toLowerCase().startsWith("drop")) {
        try {
          statement.executeUpdate(sqlLine);
        } catch(Exception e) {
        }
      } else {
        statement.executeUpdate(sqlLine);
      }
    }
    statement.close();
    con.close();
  }
/*
public void executeUpdateFromFile(String sqlFile) throws Exception {
sqlFile = sqlFile.replace('/', File.separatorChar);
sqlFile = sqlFile.startsWith(".") ? sqlFile.substring(1) : File.separator + sqlFile;
sqlFile = root + sqlFile;
FileInputStream fis = new FileInputStream(sqlFile);
int size = (int) sqlFile.length();
byte[] data = new byte[size];
fis.read(data, 0, data.length);
fis.close();
String s = new String(data);
executeUpdate(s);
}
*/
  public ResultSet executeQuery(String query) throws Exception {
    if(qcon == null && qstate == null) {
      qcon = DriverManager.getConnection(DBURL, DBUser, DBPassword);
      qstate = qcon.createStatement();
    }
    return qstate.executeQuery(query);
  }

  public void close() throws Exception {
    if(!toClose){
      //lookup
      NamingEnvironmentImpl naming = new NamingEnvironmentImpl();
      naming.init(this.p);
//RK      ServiceAdministrator sa = ((RemoteAdminInterface)naming.lookup(ADMIN)).getServiceAdministrator();
//RK      DataSourceManager dm = (DataSourceManager)sa.generateCurrentManagementInterfaceProxy(DBPOOL);
      DataSourceManager dm = (DataSourceManager) new ManagementInterfaceProxyFactoryImpl(naming.getContext().getEnvironment()).generateCurrentManagementInterfaceProxy(DBPOOL, DataSourceManager.class);
//KR
      toClose = true;
      for(int i = 0; i < pools.size(); i++) {
        System.out.println("[Database Environment] Removing databse application : " + pools.get(i));
        try {
          dm.removeApplication((String) pools.get(i));

        } catch(Exception exc) {
          System.out.println("[Database Environment] Error removing databse application : " + pools.get(i));
          exc.printStackTrace();
        }
      }
      if(!isServerDriverUsed) {
        try {

          dm.undeployJdbcDriver(DBDriver);
        } catch(Exception exc) {
          System.out.println("[Database Environment] Error in undeploy of driver : " + DBDriver);
          exc.printStackTrace();
        }
      }

      if(qstate != null) {
        qstate.close();
        qcon.close();
      }
    }
  }

}