package com.inqmy.ats.system;

import com.inqmy.ats.ClusterEnvironment;
import com.sap.engine.services.adminadapter.interfaces.*;
import com.sap.engine.services.adminadapter.descriptor.ComponentDescriptor;
import com.sap.engine.services.adminadapter.impl.ManagementInterfaceProxyFactoryImpl;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.container.monitor.ServiceMonitor;


import java.util.*;
import java.io.BufferedReader;
import java.io.StringReader;
import java.io.IOException;

/**
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public class ClusterEnvironmentImpl implements ClusterEnvironment {

  private int[] serverIds;
  private int[] dispatcherIds;
  private String[] serverNames;
  private String[] dispatcherNames;
  private boolean isCluster = false;

  private Hashtable startedServices = new Hashtable();
  private Hashtable stoppedServices = new Hashtable();
  private HashMap clusterInfoes = new HashMap();
  private ConvenienceEngineAdministrator admin;

  private ComponentAdministrator ca;

  private Properties p;


  /**
   * Initializes environemnt.This method is invoked every time when instance of environemnt is created.
   *
   * @param p          Properties that are passed to environment.
   * @throws Exception if initialization error occurs.
   */
  public void init(Properties p) throws Exception {
    NamingEnvironmentImpl naming = new NamingEnvironmentImpl();
    naming.init(p);
    this.p = p;

    RemoteAdminInterface rai = (RemoteAdminInterface)naming.lookup("adminadapter");
    ca = rai.getServiceAdministrator();
    admin = rai.getConvenienceEngineAdministrator();
    int[] nodes = admin.getClusterNodeIds();

    Vector servers = new Vector();
    Vector dispatchers =  new Vector();

    for(int i = 0 ; i < nodes.length ; i++) {
      byte clusterType = admin.getClusterNodeType(nodes[i]);
      if(clusterType == ClusterElement.SERVER) {
        servers.add(nodes[i] +"");
      } else if(clusterType == ClusterElement.DISPATCHER) {
        dispatchers.add(nodes[i] + "");
      }
    }
    serverIds = new int[servers.size()];
    serverNames = new String[servers.size()];
    for(int i = 0 ; i < serverIds.length ; i++) {
      serverIds[i] = Integer.parseInt((String)servers.elementAt(i));
      serverNames[i] = admin.getClusterNodeName(serverIds[i]);
    }
    dispatcherIds =  new int[dispatchers.size()];
    dispatcherNames = new String[dispatchers.size()];
    for(int i = 0 ; i < dispatcherIds.length ; i++) {
      dispatcherIds[i] = Integer.parseInt((String)dispatchers.elementAt(i));
      dispatcherNames[i] = admin.getClusterNodeName(dispatcherIds[i]);
    }
    if(dispatcherIds.length > 1 || serverIds.length > 1) {
      isCluster = true;
    }
    ManagementInterfaceProxyFactoryImpl factory = new ManagementInterfaceProxyFactoryImpl(naming.getContext().getEnvironment());
    for(int  i = 0 ; i < serverIds.length ; i++) {
      Object ats = factory.generateManagementInterfaceProxy(serverIds[i] , "atservice");
      String info  = (String)ats.getClass().getMethod("getNodeInfo"  , null).invoke(ats ,null);
      clusterInfoes.put(String.valueOf(serverIds[i]) , parseInfoString(info));
    }

  }

  private Properties parseInfoString(String info) {
    Properties props = new Properties();
    BufferedReader reader = new BufferedReader(new StringReader(info));
    String line = null;
    while(true) {
      try {
        line = reader.readLine();
        if(line == null) break;
        int index = line.indexOf(":");
        if(index != -1) {
          props.put(line.substring(0, index).trim() , line.substring(index + 1).trim());
        }
      } catch(IOException e) {
      }
    }
    return props;
  }



  /**
   * Closes Environment. Method behaviour depends on Environment interface implementation.
   *
   * @throws Exception if error occurs.
   */
  public void close() throws Exception {

    Vector services = new Vector();
    NamingEnvironmentImpl naming = new NamingEnvironmentImpl();
    naming.init(this.p);
    RemoteAdminInterface rai = (RemoteAdminInterface)naming.lookup("adminadapter");
    admin = rai.getConvenienceEngineAdministrator();

    // start all services stopped during the test
    for (Enumeration e = stoppedServices.keys(); e.hasMoreElements(); ) {
      int key = Integer.parseInt((String)e.nextElement());
      services = (Vector)(stoppedServices.get(key + ""));
      for (Iterator i = services.iterator(); i.hasNext(); ) {
        admin.startService(key, (String)i.next());
        i.remove();
      }
    }
    // stop all services started during the test
    for (Enumeration e = startedServices.keys() ;e.hasMoreElements(); ) {
      int key = Integer.parseInt((String)e.nextElement());
      services = (Vector)(startedServices.get(key + ""));
      for (Iterator i = services.iterator(); i.hasNext(); ) {
        admin.stopService(key, (String)i.next());
        i.remove();
      }
    }


//System.out.println("----close() end:------------ ");
//System.out.println(startedServices.toString());
//System.out.println(stoppedServices.toString());

    services = null;
    stoppedServices.clear();
    startedServices.clear();

  }

  /**
   *
   * @param serviceName
   * @param clusterIds
   * @throws Exception
   */
  public void stopService(String serviceName, int[] clusterIds) throws Exception {
    Vector start = new Vector();
    Vector stop = new Vector();

    for (int i=0; i<clusterIds.length; i++) {
      try {
        ComponentDescriptor des = ca.getDescriptor(clusterIds[i] , serviceName);
        if (des.getStatus() != ServiceMonitor.STATUS_ACTIVE) { // if the service is already started
          continue;
        }
        stop = (Vector)stoppedServices.get(clusterIds[i] + "");
        if ((stop == null) || (!stop.contains(serviceName))) {
          admin.stopService(clusterIds[i], serviceName);
          // if the started service has been previously stopped.
          // remove from the stopped hash table
          start = (Vector)startedServices.get(clusterIds[i] + "");
          if((start != null) && (start.contains(serviceName))) {
              start.remove(serviceName);
          }
          else {
            if (stop == null) { stop = new Vector(); }
            stop.add(serviceName);
            stoppedServices.put(clusterIds[i] + "", stop);
          }

        }
      } catch (NullPointerException exp) { }
    }

    start = null;
    stop = null;
  }

  public boolean isServiceStarted(String serviceName, int clusterId) throws Exception {
    ComponentDescriptor des = ca.getDescriptor(clusterId, serviceName);
    if (des.getStatus() == ServiceMonitor.STATUS_ACTIVE) { // if the service is already starte
      return true;
    } else {
      return false;
    }
  }

  public Properties getServerInfo(int clusterId) {
    return (Properties)clusterInfoes.get(String.valueOf(clusterId));
  }

  public String getServerInfo(int clusterId, String keyName) {
    Properties p = (Properties)clusterInfoes.get(String.valueOf(clusterId));
    if(p != null) {
      return p.getProperty(keyName);
    } else {
      return null;
    }
  }

  /**
   *
   * @param serviceName
   * @param clusterIds
   * @throws Exception
   */
  public void startService(String serviceName, int[] clusterIds) throws Exception {
    Vector start = new Vector();
    Vector stop = new Vector();

    for (int i=0; i<clusterIds.length; i++) {
      try {
        ComponentDescriptor des = ca.getDescriptor(clusterIds[i] , serviceName);
        if (des.getStatus() == ServiceMonitor.STATUS_ACTIVE) { // if the service is already started
          continue;
        }
        start = (Vector)startedServices.get(clusterIds[i] + "");
        if ((start == null) || (!start.contains(serviceName))) {
          admin.startService(clusterIds[i], serviceName);
          // if the started service has been previously stopped.
          // remove from the stopped hash table
          stop = (Vector)stoppedServices.get(clusterIds[i] + "");
          if((stop != null) && (stop.contains(serviceName))) {
              stop.remove(serviceName);
          }
          else {
            if (start == null) { start = new Vector(); }
            start.add(serviceName);
            startedServices.put(clusterIds[i] + "", start);
          }
        }
      } catch (NullPointerException exp) { }
    }
    start = null;
    stop = null;
  }

  /**
   *
   * @return
   */
  public boolean isCluster() {
    return isCluster;
  }

  /**
   *
   * @return
   */
  public int[] getDispatcherIds() {
    return dispatcherIds;
  }

  /**
   *
   * @return
   */

  public int[] getServerIds() {
    return serverIds;
  }

  public String[] getServerNames() {
    return serverNames;
  }

  public String[] getDispatcherNames(){
    return dispatcherNames;
  }

}
