package com.inqmy.ats.additional;

import java.util.*;
import java.io.*;
import com.inqmy.ats.LogEnvironment;
import com.inqmy.ats.provider.TestContext;
import com.inqmy.ats.provider.ResultInfo;
import com.inqmy.ats.provider.CoreContext;


public class LogEnvironmentImpl implements LogEnvironment {

  static PrintStream outStream;
  
  static String currentMethod = "";

  private TestContext tc = null;

	private ResultInfo info;

  private String log ;

  private boolean toClose = false;

  private String logDirName;

  
  public LogEnvironmentImpl() throws Exception {
    tc = CoreContext.getTestContext();
    log = tc.getLogDir();
    File logDir = new File(log);
    logDirName = logDir.getName();
    makeDirs(logDir);
  }

  //public void setMaxSeverityErrorLevel(int level) {
    //To change body of implemented methods use File | Settings | File Templates.
  //}

  public String getLogDir() {
    return log;
  }

  public void init(Properties p) {
  }

  public void excludeServerLog(String type,String message) {
    try {
      tc.getTestEnvironment().getWrapper().getInfo().setSeverity(Integer.parseInt(type));
    } catch (Exception e) {
      log(e);
      throw new RuntimeException("Internal error in setting severity " + e.getMessage());
    }
  }

  public File getExternalLogFile() {
   TestContext t = CoreContext.getTestContext();
   File ff = new File(t.getLogDir() + File.separatorChar + t.getTestClassLogName() + "." + t.getCurrentMethodName() + ".externalLog.txt");
   return ff.exists() ? ff : null;
  }

  public void setResultLinkFile(String link) {
    try {
      info = (tc.getTestEnvironment().getWrapper()).getInfo();
      info.setResultLink("Status" , link);
    } catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void makeDirs(File parent) {
    if(parent != null && !parent.exists()) {
      parent.mkdirs();
    }
  }

  public void log(String message) {
    getStream();
    outStream.println(message);
  }

  public void log(byte[] b, int off, int len) {
    getStream();
    outStream.write(b, off, len);
  }

  public void log(Throwable throwable) {
    getStream();
    throwable.printStackTrace(outStream);
  }


  //this method is to log in different files without creating new LogEnvironmentImpl
  private synchronized void getStream() {
    try {
    info = tc.getTestEnvironment().getWrapper().getInfo();
    }catch(Exception e) {
    }    
    String methodName = tc.getCurrentMethodName();
//System.out.println("MAKING LOG DIR = " + log);    
    makeDirs(new File(log));
    //if currentMethod == null means log is using in test constructor
    if (methodName == null) {
      try {
        if( outStream == null ) {

          outStream = new PrintStream(new FileOutputStream(log + File.separator + tc.getTestClassLogName() + ".txt") , true);
        }
      } catch(Exception exc) {
        System.out.println(" ERROR GETTING LOG STREAM :  " + exc);
      }
    } else {
      if (!methodName.equals(currentMethod)) {
         currentMethod = methodName;
         try {
           if( outStream != null ) {
             try {
              outStream.close();
             } catch(Exception e) {}
           }
           outStream = new PrintStream(new FileOutputStream(log + File.separator + tc.getTestClassLogName() +"."+ currentMethod + ".Status.txt") , true);
         } catch(Exception exc) {
           System.out.println(" ERROR GETTING LOG STREAM :  " + exc);
         }
      }
    }
  }

  public void close() {
    try {
      outStream.close();
    } catch(Exception e) {
    }
  }
  
  public void setInfoValue(String infoValue) {
    try {
      info = tc.getTestEnvironment().getWrapper().getInfo();
      info.setClassInfo(infoValue);
    }catch(Throwable e) {
			e.printStackTrace();
    }
  }

  
}
