package com.inqmy.ats;

import java.rmi.RemoteException;

public interface UserEnvironment extends Environment {

  public void createUser(String name, String password, String[] parentGroup) throws SecurityException , RemoteException;

  public void createGroup(String name, String[] parentGroup) throws SecurityException , RemoteException;

  public void group(String item, String group, boolean isUser) throws SecurityException , RemoteException;

  public void ungroup(String item, String group, boolean isUser) throws SecurityException , RemoteException;

  public int getUserId(String name, boolean user) throws SecurityException , RemoteException;

  public void create(String userScript) throws Exception;

  public void removeUser(String name) throws SecurityException , RemoteException;

  public void removeGroup(String name) throws SecurityException , RemoteException;

}
