package com.inqmy.ats;

import java.util.*;
import java.io.*;
/**
 * This interface provides methods for getting some basic information about test
 * life cycle.
 *
 */
public interface TestEnvironment extends Environment {
  /**
   * Returns canonical path of the test root directory.
   *
   * @return test directory path
   */
  public String getRootDir();
  /**
   * Returns ats default test properties
   *
   * @return Properties containing ats default test properties
   */
  public Properties getProperties();
  /**
   * Returns properties that are loaded from specified file.
   * File name that is passed <param>propertiesName</param> is
   * name of file in the test root directory.
   *
   * @param propertiesName name of property file.
   * @return Properties that file contains
   */
  public Properties getProperties(String propertiesName);
  /**
   * Returns stream for reading from file with name <param>fileName</param>.
   * This file have to be placed in the test root directory.
   *
   * @param fileName name of file
   * @return InputStream for reading from file.
   * @throws IOException if i/o error occurs.
   */
  public InputStream getFileInputStream(String fileName) throws IOException;
  /**
   * Returns file with name <param>fileName</param>.
   * This file have to be placed in the test root directory.
   * @param fileName name of file
   * @return File with name <param>fileName</param>.
   * @throws IOException if i/o error occurs.
   */
  public File getFile(String fileName) throws IOException;
  /**
   * Set timeout of the test. A test can define with this method
   * its timeout only in constructor.
   * Setted timeout is valid for all test methods in test class.
   *
   * @param timeout time out of test in minutes.
   * @throws Exception if method is not called in the test constructor.
   */
  public void setTimeout(long timeout) throws Exception;

  /**
   * Returns String that contains all class path for test.
   * This is class path that is defined in <ATS_HOME>/bin/classPaths.properties file.
   * @return test class path
   */
  public String getCommonTestClassPath();
}
