package com.inqmy.ats;

/**
 * This interface represents an environment for working with telnet protocol.
 *
 */

public interface ShellEnvironment extends Environment {

  /**
   * Sends given string to SAP J2EEngine server using telent protocol.
   *
   * @param line       string to send to SAP J2EEngine sever.
   * @return           SAP J2EEngine server response.
   * @throws Exception if i/o error occurs.
   */
  public String execCommand(String line) throws Exception;

  /**
   * Sends strings to SAP J2EEngine server using telent protocol.
   * Method reads lines from given file and sends them one by one
   * to SAP J2EEngine server using telnet protocol.
   *
   * @param file       name of file.
   * @return           array of strings representing SAP J2EEngine server responses.
   * @throws Exception if i/o error occurs.
   */
  public String[] execScript(String file) throws Exception;

  /**
   * Retrieves ids of dispatchers which are connected in SAP J2EEngine cluster.
   * Method executes command "lsc" on SAP J2EEngine using telnet protocol and parses response.
   *
   * @return int array of current dispatchers ids.
   */
  public int[] getDispatcherIds();

  /**
   * Retrieves ids of servers which are connected in SAP J2EEngine cluster.
   * Method executes command "lsc" on SAP J2EEngine using telnet protocol and parses response.
   *
   * @return int array of current servers ids.
   */
  public int[] getServerIds();

}
