package com.inqmy.ats;

import javax.naming.*;
import javax.naming.directory.*;
/**
 * This intrface provides method for working with naming.
 */
public interface NamingEnvironment extends Environment {
  /**
   * Constructs an initial context using the default test properties and
   * passed user name and user password.
   *
   * @param user     user name
   * @param password user password
   * @return
   * @throws NamingException if a naming exception is encountered
   */
  public Context getContext(String user, String password) throws NamingException;
  /**
   * Constructs an initial context using the default test properties.
   *
   * @return InitialContext
   * @throws NamingException if a naming exception is encountered
   */
  public Context getContext() throws NamingException;
  /**
   * Constructs an initial DirContext using the default test properties and
   * passed user name and user password.
   *
   * @param user     user name
   * @param password user password
   * @return DirContext
   * @throws NamingException if a naming exception is encountered
   */
  public DirContext getDirContext(String user, String password) throws NamingException;
  /**
   * Constructs an initial DirContext using the default test properties.
   * @return DirContext
   * @throws NamingException if a naming exception is encountered
   */
  public DirContext getDirContext() throws NamingException;
  /**
   * Look up object that is bind in naming with name <param>lookupName</param>.
   *
   * @param lookupName name of specified object in naming.
   * @return object which is bind to specified name
   * @throws NamingException if there is no bind object with <param>lookupName</param> name.
   */
  public Object lookup(String lookupName) throws NamingException;

}
