package com.inqmy.ats;

import java.io.File;
/**
 * You can get this Environment in test which impelments one of the
 * interfaces com.inqmy.ats.Test or com.inqmy.ats.ServerTest.
 * This interface provides methods for storing information in file.
 * Such file is called "log file".It is placed in directory which
 * canonical pathname is concatenation of canonical pathname of directory
 * "<ATS_HOME>/bin/log/" and relative pathname from main test directory
 * to directory of test, which uses this environment."Log file" filename is
 * concatenation of class name of test and name of method in which this
 * environment is used. Here is simple example.
 * If main tests directory is "D:/develop/ATS/dev/tests"
 * and the test directory is "D:/develop/ATS/dev/tests/check/http/getTests"
 * (relative test pathname is "check/http/getTests") then
 * "log file" pathname will be "D:/develop/ATS/dev/bin/log/check/http/getTests".
 * If test class name is "MyTest" and method which uses LogNvironment has name
 * "testMethod", then "log file" name will be "MyTest.testMethod.txt".
 * In final result in generated html file with test result link of the test
 * result status points to such "log file" by default.
 * There is method which gives test ability to change this link.
 * Here is a simple example how to use this interface.
 *  <pre>
 *  import java.io.*;
 *  import com.inqmy.ats.Test;
 *  import com.inqmy.ats.LogEnvironment;
 *  import com.inamy.ats.system.EnvironmentFactory;
 *
 *  public class MyTest implements com.inqmy.ats.Test {
 *    LogEnvironment log;
 *    public MyTest() {
 *      try {
 *        log  = (LogEnvironment)EnvironmentFactory.getEnvironment(EnvironmentFactory.LOG);
 *      } catch(Exception exc) {
 *        exc.printStackTrace();
 *      }
 *    }
 *    public int test1() {
 *      try {
 *        int result = 0;
 *        String fileName = "testResultFile.txt";
 *        String testLogDir = log.getLogDir();
 *        String testDirName = new File(testLogDir).getName();
 *        log.setResultLinkFile(testDirName+"/"+fileName);//set link in result test htmlpage to specefied file.
 *        log.log("Test Begin");
 *        FileOutputStream out = new FileOutputStream(testLogDir + File.separator + fileName);
 *        ...................
 *        //here goes some kind of test logic
 *        ...................
 *        out.close();
 *        log.log("Test End");
 *        return result;
 *      } catch(Exception exc) {
 *        log.log("Error occured in test");
 *        log.log(exc);
 *        return 0;
 *      }
 *    }
 *    public int test2() {
 *      try {
 *        int result = 0;
 *        log.log("Test Begin");
 *        //There is no need to take LogEnvironment from EnvironmentFactory in every method .
 *        // You can use one instance of LogEnvironment in different methods of test class.
 *        ...................
 *        //here goes some kind of test logic
 *        ...................
 *        log.log("Test End");
 *        return result;
 *      } catch(Exception exc) {
 *        log.log("Error occured in test");
 *        log.log(exc);
 *        return 0;
 *      }
 *    }
 *  }
 *    </pre>
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */
public interface LogEnvironment extends Environment {
  /**
   * Stores passed String to the test log file
   * @param message data to store
   */
  public void log(String message);
  /**
   * Method takes <param>len</param> number of bytes
   * starting from index <param>off</param> in passed byte[].
   * Then writes their String presentation in the test log file.
   *
   * @param b byte array
   * @param off the start offset in the data.
   * @param len the number of bytes.
   */
  public void log(byte[] b, int off, int len);
  /**
   * Stores throwable stackTrace to test log file
   * @param throwable Throwable instance
   */
  public void log(Throwable throwable);

  /**
   * Returns canonical path of test log directory.
   *
   * @return path of the log directory of the test
   */
  public String getLogDir();
  /**
   * Set specified link <param>link</param> in final html result page of the test.
   *
   * @param link new link
   */
  public void setResultLinkFile(String link);
  /**
   * When test has finished, all logs made on
   * server are wrote in a specified file in the test
   * log directory (in case this option is switched on).
   * In final result this log is parsed and result is
   * generated(OK or respectively ERROR). Result is considered
   * for error if some log type in log matches with a
   * string in the value of property with key "log_server_error_strings"
   * in default proeprties.
   * With his method you can "exclude" such "error" strings.
   * @param type
   * @param message
   */
  public void excludeServerLog(String type,String message);
  /**
   * Sets test information message.
   * Link to this message is set in final result html page.
   *
   * @param infoValue info String
   */
  public void setInfoValue(String infoValue);
  /**
   * Retruns java.io.File containing log messages that are made outside ATS.
   * If there is no externel message then null is returned.
   * @return returns java.io.File containing log that are mede outside ATS.
   */
  public File getExternalLogFile();

}
