package com.inqmy.ats;

/**
 * Instance of this class is thrown if some kind of error in http protocol
 * occurs.
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public class HttpException extends Exception {

  private Object o;
  /**
   * Constructs HttpException instance with specified message.
   *
   * @param message exception message.
   */
  public HttpException(String message) {
    super(message);
  }
  /**
   * Constructs HttpException instance with specified message and object.
   *
   * @param message exception message.
   * @param o       result from method execution.
   */
  public HttpException(String message, Object o) {
    this(message);
    this.o = o;
  }
  /**
   * Returns object that is result from method that throws this exception.
   * If method is void then return value will be null.
   * @return Object containing result from method in which excpetion is thrown.
   */
  public Object getResourceObject() {
    return o;
  }
}
