package com.inqmy.ats;
  
import java.io.*;
import java.util.*;

/**
 * Environment interface that providers methods for making http requests and
 * receiving their responses. A test can use this interface (got from
 * EnvironmentFactory) for requesting http resources (servlets , jsp , etc.).
 * Implementation class (of this interface) that a test gets has functionality
 * for making automatic observing for http errors (excluding i/o errors). In this case
 * an HttpException is thrown. If request are read from file and such http error occurs then
 * HttpException is thrown after all requests (that file contains) are made.
 * File with http requests have specified structure. It is recommended to use ats http-proxy tool.
 * To start this tool just set client end server port in file <ATS_HOME>/bin/tools/http/proxy.properties
 * and execute /bin/tools/http/goproxy.bat. Now you can use browser to request server through http-tool.
 * It will automatically save requests in file by the proper way. If you write manual requests in
 * http requests file then probably no requests will be made!
 *
 */
public interface HttpEnvironment extends Environment {


  /**
   * Makes http requests read from file in a test directory with name,
   * specified in environment property(value of key "requests_file"), and sends
   * them to http server. For every request a response is received (header and body).
   * Response source bytes are written in log file of the test.
   * After all requests have finished then check for error massages in responses
   * (messages are value of key "errors_strings" in environment properties
   * , separated from ";" symbol) is made.
   * If there are no such messages then method returns 1 - 0 otherwise.
   *
   * @return 0 if error string if found in response 1 otherwise.
   * @throws IOException if read/write Exception occurs.
   * @throws HttpException  if http protocol error occurs.
   */
  public int check() throws IOException , HttpException;

  /**
   * This method makes http requests read from file in test directory with name,
   * specified in the environment property(value of key "requests_file"), and sends
   * them to http server. For every request it receives response (header and body), and
   * writes it's source bytes in the log file of the test. After all requests are made, method
   * " int compare(Object o1, Object o2) " of instance of java.util.Comparator that is passed
   * to method as first parameter is called. First parameter of compare method is
   * java.io.File , representing log file of test(contains http response logs).
   * Second parameter is <code>secondParameter</code>. This method is used when test wants to
   * define correctness of responses.
   * Int value that the comparator returns is returned as a result from this method.
   *
   * @param comparator instance of java.util.Comparator
   * @param secondParameter value for second parameter of passed Comparator instance
   * @return int value from compare method of passed Comparator instance.
   * @throws IOException if read/write Exception occurs
   * @throws HttpException if http protocol error occurs.
   */
  public int check(Comparator comparator , Object secondParameter) throws IOException , HttpException;

  /**
   * Method for making single http request.This method return Hashtable with two keys.
   * 1) "body" - it's value is byte[] presentation of the body of the response.
   * 2) "headers" - it's value is String[] holding header lines of response.
   *
   * @param request header of http request
   * @return Hashtable containing body of response and String[] of response header.
   *
   * @throws HttpException if http protocol error occurs .
   * @throws IOException if i/o problems occurs while reading/writing to socket.
   */
  public Hashtable singleRequest(String request) throws IOException , HttpException;

  /**
   * Use to obtain relative path from current test log directory to
   * response body log file of the last response.
   * If no log is created then null is returned.
   *
   * @return relative path to file in which last response body is logged.
   */
  public String getHttpResponseLogRelativePath();

}

