package com.inqmy.ats;

import java.util.Properties;
/**
 * This interface is the base of all Environment interfaces that gives test different kind of functionality.
 * Every Environment interface must extend it. Environment implementation has not to perform any
 * initialization in it's constructor.
 */
public interface Environment {
  /**
   * Initializes environemnt.This method is invoked every time when instance of environemnt is created.
   *
   * @param p          Properties that are passed to environment.
   * @throws Exception if initialization error occurs.
   */
  public void init(Properties p) throws Exception;
  /**
   * Closes Environment. Method behaviour depends on Environment interface implementation.
   *
   * @throws Exception if error occurs.
   */
  public void close() throws Exception;

}
